/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cMQl
 */

package {
    import flash.display.*;
    import flash.events.*;
    [SWF(width='465', height='465', backgroundColor='#222222', frameRate='30')]
    public class Game extends Sprite {
        public static var me: Game;
        public static var ship: Ship;
        public static var goodBullets: Vector.<GoodBullet>;
        public function Game() {
            me = this;
            goodBullets = new Vector.<GoodBullet>();
            ship = new Ship();
            addChild(ship);
            ship.init();
            
            stage.focus = stage;
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event: Event): void {
            ship.update();
            for each (var goodBullet: GoodBullet in goodBullets) {
                goodBullet.update();
            }
        }
    }
}


import flash.display.*;
import flash.events.*;
import flash.ui.Keyboard;
class Ship extends Sprite {
    private static const radius: Number = 10;
    private static const speed: Number = 6;
    private static const maxCharge: Number = 100;
    private static const chargeRate: Number = 1;
    
    private var left: Boolean = false;
    private var right: Boolean = false;
    private var up: Boolean = false;
    private var down: Boolean = false;
    private var trigger: Boolean = false;
    private var triggerReleased: Boolean = false;
    
    private var xDir: Number = 0;
    private var yDir: Number = 0;
    
    private var charge: Number = 0;
    
    public function Ship() {
        graphics.clear();
        graphics.beginFill(0xffffff);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        x = 232.5;
        y = 232.5;
    }
    
    public function init(): void {
        stage.quality = StageQuality.LOW;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
    }
    
    public function update(): void {
        x += xDir * speed;
        y += yDir * speed;
        if (trigger) {
            charge += chargeRate;
            if (charge > maxCharge) charge = maxCharge;
        }
        if (triggerReleased) {
            new GoodBullet(x, y, charge);
            charge = 0;
        }
        triggerReleased = false;
    }
    
    private function onKeyDown(event: KeyboardEvent): void {
        switch (event.keyCode) {
            case Keyboard.LEFT:
                left = true;
                xDir = -1;
                break;
            case Keyboard.RIGHT:
                right = true;
                xDir = 1;
                break;
            case Keyboard.UP:
                up = true;
                yDir = -1;
                break;
            case Keyboard.DOWN:
                down = true;
                yDir = 1;
                break;
            case Keyboard.SPACE:
                trigger = true;
                break;
        }
    }
    
    private function onKeyUp(event: KeyboardEvent): void {
        switch (event.keyCode) {
            case Keyboard.LEFT:
                left = false;
                xDir = right ? 1 : 0;
                break;
            case Keyboard.RIGHT:
                right = false;
                xDir = left ? -1 : 0;
                break;
            case Keyboard.UP:
                up = false;
                yDir = down ? 1 : 0;
                break;
            case Keyboard.DOWN:
                down = false;
                yDir = up ? -1 : 0;
                break;
            case Keyboard.SPACE:
                trigger = false;
                triggerReleased = true;
                break;
        }
    }
}

class GoodBullet extends Sprite {
    private static const speed: Number = 25;
    
    public var power: Number;
    public function GoodBullet(x: Number, y: Number, charge: Number) {
        power = charge + 2;
        graphics.clear();
        graphics.beginFill(0xffffff);
        graphics.drawCircle(0, 0, power);
        graphics.endFill();
        
        this.x = x;
        this.y = y;
        scaleX = 3;
        
        Game.me.addChild(this);
        Game.goodBullets[Game.goodBullets.length] = this;
    }
    
    public function update(): void {
        x += speed;
        if (x > 465 + power*3) destroy();
    }
    
    public function destroy(): void {
        Game.me.removeChild(this);
        Game.goodBullets.splice(Game.goodBullets.indexOf(this),1);
    }
}




