/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cLon
 */

package
{
import flash.events.Event;
import org.papervision3d.materials.special.Letter3DMaterial;
import org.papervision3d.typography.Font3D;
import org.papervision3d.typography.Text3D;
import org.papervision3d.typography.fonts.HelveticaBold;
import org.papervision3d.view.BasicView;
public class Text3DTemplate extends BasicView
{
private var material:Letter3DMaterial;
private var font3D:Font3D;
private var text3D:Text3D;
private var easeOut:Number = 0.6;
private var reachX:Number = 0.5
private var reachY:Number = 0.5
private var reachZ:Number = 0.5;
public function Text3DTemplate()
{
stage.frameRate = 40;
init();
startRendering();
}
private function init():void
{
var text:String = "It\'s \na \nWonderfl\nWonderfl Wrld\n  ;-)";
material = new Letter3DMaterial(0xffff00);
font3D = new HelveticaBold();
text3D = new Text3D(text,font3D,material);
text3D.x = 0;
text3D.y = 200;
text3D.localRotationY = 0;
text3D.scale = 1.5;
text3D.align = "center";
text3D.letterSpacing = -3;
text3D.lineSpacing = -30;
text3D.material.lineThickness = 2;
text3D.material.lineAlpha = 1;
text3D.material.lineColor = 0x000000;
scene.addChild(text3D);
}
override protected function onRenderTick(event:Event = null):void
{
var xDist:Number = mouseX - stage.stageWidth * 0.5;
var yDist:Number = mouseY - stage.stageHeight * 0.25;
camera.x += (xDist - camera.x * reachX) * easeOut;
camera.y += (yDist - camera.y * reachY) * easeOut;
camera.z += (-mouseY * 2 - camera.z ) * reachZ;
super.onRenderTick();
}
}
}