/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cKvO
 */

// forked from mousepancyo's Away3D Gold Line Example
package
{
    import flash.display.BitmapData;
    import away3d.cameras.Camera3D;
    import away3d.cameras.lenses.PerspectiveLens;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.entities.SegmentSet;
    import away3d.filters.BloomFilter3D;
    import away3d.filters.DepthOfFieldFilter3D;
    import away3d.filters.MotionBlurFilter3D;
    import away3d.primitives.LineSegment;
    import away3d.primitives.WireframePlane;
    
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;
    
    [SWF(backgroundColor="#C0C0C0", frameRate="60", width="465", height="465")]
    
    public class DrawLine extends Sprite
    {
        
        private var _view : View3D;
        private var _scene : Scene3D;
        private var _camera : Camera3D;
        
        private var _lines:SegmentSet;
        
        //private var _bmd:BitmapData = new BitmapData(465, 465, false, 0);;
        
        public function DrawLine()
        {
            Wonderfl.disable_capture();
            
            setup();
            //addChild( new Bitmap( _bmd ) );
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function setup():void
        {
            _view = addChild(new View3D()) as View3D;
            _view.antiAlias = 6;
            _view.backgroundColor = 0;
            
            var lens:PerspectiveLens = new PerspectiveLens( 90 );
            _view.camera.lens = lens;
            
            
            _scene = _view.scene;
            
            _camera = _view.camera;
            _camera.x = 100;
            _camera.y = 500;
            _camera.z = -2000;
            
            _lines = new SegmentSet();
            _scene.addChild( _lines );
            
            var plane:WireframePlane = new WireframePlane( 3000, 3000, 10, 10 ,0x30FF99, 2);
            plane.rotationZ = 90;
            _scene.addChild(plane);
            
            var motionBlur:MotionBlurFilter3D = new MotionBlurFilter3D(.9);
            var bloom:BloomFilter3D = new BloomFilter3D( 4, 4, .75, 4, 4);
            _view.filters3d = [motionBlur, bloom];
            
            var awayStats:AwayStats = new AwayStats(_view);
            addChild(awayStats);
        }
        
        private function lineDraw():void
        {
            _lines.addSegment(
                new LineSegment(
                    new Vector3D( 0, 0, 0 ),
                    new Vector3D( -500, 250, 0),
                    0xFFFFFF,
                    0xFFFFFF,
                    2
                )
            )
            _lines.addSegment(
                new LineSegment(
                    new Vector3D( -500, 250, 0 ),
                    new Vector3D( 0, 500, 0 ),
                    0xFFFFFF,
                    0xFFFFFF,
                    2
                )
            )
            _lines.addSegment(
                new LineSegment(
                    new Vector3D( 0, 500, 0 ),
                    new Vector3D( 500, 500, 500 ),
                    0xFFFFFF,
                    0xFFFFFF,
                    2
                )
            )
            _lines.addSegment(
                new LineSegment(
                    new Vector3D( 500, 500, 500 ),
                    new Vector3D( 500, 200, -500 ),
                    0xFFFFFF,
                    0xFFFFFF,
                    2
                )
            )
        }
        
        private var _currentV3D:Vector3D = new Vector3D();
        private var _segList:Array = [];
        
        
        private function update(e:Event) : void
        {
            
            if( _segList.length > 5000 ) 
            {
                _lines.removeAllSegments();
                _segList = [];
            }
            
            var v3D:Vector3D = new Vector3D( (Math.random() * 2500 - 1250) | 0, (Math.random() * 1500) | 0, (Math.random() * 2500 - 1250) | 0);
            
            var seg:LineSegment = new LineSegment(
                _currentV3D,
                v3D,
                Math.random() * 0xFFFFFF | 0,
                Math.random() * 0xFFFFFF | 0,
                1
            )
            
            _lines.addSegment( seg );
            
            _segList.push( seg );
            
            _currentV3D = v3D;
            
            _camera.x = 1000 * Math.sin(getTimer() / 2000);
            _camera.z = 2500 * Math.cos(getTimer() / 2000);
            _camera.y = 1000 * Math.sin(getTimer() / 5000) - 200;
            _camera.lookAt(new Vector3D());
            _view.render();
            
            //_view.renderer.queueSnapshot( _bmd );
        }
        
        
    }
}