/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cK39
 */

// forked from makc3d's AudioTool test
// forked from makc3d's BeatPort player
package {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	/**
	 * Audiotool Player v2,
	 * this time API-based.
	 */
	public class Audiotool extends Sprite {
		private var player:AudioToolPlayer
		public function Audiotool () {
			AudioToolPlayer (player = new AudioToolPlayer).play ();
			stage.addEventListener (MouseEvent.CLICK, nextTrack);
		}
		private function nextTrack (e:MouseEvent):void {
			player.next ();
		}
	}
}

import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;

class AudioToolPlayer {
	public function next ():void {
		if (channel) {
			channel.stop ();
			playNextTrack (new Event ("whatever"))
		}
	}

	/**
	 * Plays audiotool tracks in listing order.
	 */
	public function play ():void {
		loadTracks ();
	}
	
	protected function loadTracks ():void {
		var loader:URLLoader = new URLLoader;
		loader.dataFormat = URLLoaderDataFormat.BINARY;
		subscribeLoader (loader, getTracksInPage, onIOFailure1);
		loader.load (new URLRequest ("http://api.audiotool.com/documents/relevant"));
	}
	

	private function makeUrl (key:String):String {
		return "http://api.audiotool.com/play/" + key + "/s3.mp3";
	}

	private var tracks:Array = [], sound:Sound, channel:SoundChannel;
	private var context:SoundLoaderContext = new SoundLoaderContext (10, true);

	private function getTracksInPage (e:Event):void {
		var loader:URLLoader = URLLoader (e.target);
		unsubscribeLoader (loader, getTracksInPage, onIOFailure1);

		var result:XML = XML (loader.data);
		for each (var key:XML in result.document.publicKey) {
			tracks.push (makeUrl (key));
		}
		
		playNextTrack ();
	}

	private function playNextTrack (e:Event = null):void {
		if (e != null) {
			unsubscribeSoundStuff (); channel = null;
		}

		var url:String = tracks.pop ();
		tracks.unshift (url);

		trace ("playing:", url);

		channel = Sound (sound = new Sound (
			new URLRequest (url), context
		)).play ();

		subscribeSoundStuff ();
	}

	private function subscribeLoader (loader:URLLoader, onComplete:Function, onIOFailure:Function):void {
		loader.addEventListener (Event.COMPLETE, onComplete);
		loader.addEventListener (IOErrorEvent.IO_ERROR, onIOFailure);
	}

	private function unsubscribeLoader (loader:URLLoader, onComplete:Function, onIOFailure:Function):void {
		loader.removeEventListener (Event.COMPLETE, onComplete);
		loader.removeEventListener (IOErrorEvent.IO_ERROR, onIOFailure);
	}

	private function subscribeSoundStuff ():void {
		sound.addEventListener (IOErrorEvent.IO_ERROR, onIOFailure3);
		channel.addEventListener (Event.SOUND_COMPLETE, playNextTrack);
	}

	private function unsubscribeSoundStuff ():void {
		sound.removeEventListener (IOErrorEvent.IO_ERROR, onIOFailure3);
		channel.removeEventListener (Event.SOUND_COMPLETE, playNextTrack);
	}

	private function onIOFailure1 (e:IOErrorEvent):void {
		unsubscribeLoader (URLLoader (e.target), getTracksInPage, onIOFailure1);
		play ();
	}

	private function onIOFailure3 (e:IOErrorEvent):void {
		// assumes sound's ioError comes before channel's soundComplete
		unsubscribeSoundStuff ();
		playNextTrack ();
	}
}