/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cJvt
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    /**
     * MX2004時代が長かった所為でBitmapDataの扱いに弱いので練習してみる。
     */
    public class BitmapTest extends Sprite {
        
        private var bitmapData:BitmapData;
        
        //コンストラクタ
        public function BitmapTest() {
            
            /**
             * ビットマップデータ作る
             * 幅高さはステージと一緒
             * 透明度有効
             * 色は真っ黒で不透明
             */
            bitmapData = new BitmapData(stage.stageWidth, stage.stageWidth, true, 0xFF000000);
            
            //ステージに置く
            addChild( new Bitmap(bitmapData) );
            
            //ランダムにドットおいてみる
            addEventListener(Event.ENTER_FRAME,function(event:Event):void{
                bitmapData.lock();
                bitmapData.setPixel32(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight, 0xFFFF0000);
                bitmapData.unlock();
            });
            
        }
    }
}