/**
 * Copyright nbhd ( http://wonderfl.net/user/nbhd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cImW
 */

// forked from nbhd's PV3Dれんしゅー
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    
    import caurina.transitions.*;
    import caurina.transitions.properties.*;
    
    [SWF(width="465", height="465", backgroundColor="#ffffff", frameRate="60")]
    public class SphereRot extends Sprite {
        private var world:BasicView = new BasicView();
        private var sphere:Sphere;

        public function SphereRot() {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void{
            removeEventListener(Event.ADDED_TO_STAGE, init);
            addChild(world);
            
            sphere = new Sphere(null, 200, 30, 30);
            
            world.camera.z = -300;
            world.camera.focus = 5;
            
            world.scene.addChild(sphere);
            world.startRendering();
            
            addEventListener(Event.ENTER_FRAME, entFnc);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _onDown);
        }
        
        private function entFnc(e:Event):void {
            sphere.rotationY += 0.2;
        }
        
        private function _onDown(e:MouseEvent):void {
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, _onDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, _onUp);
            
            Tweener.addTween(world.camera, {
                x : 1000,
                y : Math.random()*10*100,
                time : 2
            });
        }
        
        private function _onUp(e:MouseEvent):void {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, _onDown);
            stage.removeEventListener(MouseEvent.MOUSE_UP, _onUp);
            
            Tweener.addTween(world.camera, {
                x : 0,
                y : 0,
                time : 1
            });
        }
    }
}