/**
 * Copyright kjkmr ( http://wonderfl.net/user/kjkmr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cIlQ
 */

// forked from kjkmr's flash on 2010-7-22
/*
ちょっとしたサンプル
*/
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        
        private static const _NUM_BALLS:uint = 30;
        private static const _POSITION_OFFSET:Number = 0.025;
        
        private var _balls:Array = [];
        private var _container:Sprite;
        
        public function FlashTest() {
            //
            _container = new Sprite();
            _container.x = stage.stageWidth * 0.5 >> 0;
            _container.graphics.beginFill( 0 );
            _container.graphics.drawRect( -_container.x, 0, stage.stageWidth, stage.stageWidth );
            _container.addEventListener( MouseEvent.CLICK, _reset );
            _container.buttonMode = true;
            _container.mouseChildren = false;
            addChild( _container );
            
            //
            var i:uint, b:Ball;
            for ( i=0; i<_NUM_BALLS; i++ ) {
                b = new Ball();
                _container.addChild( b );
                _balls.push( b );
            }
            
            //
            _reset();
            
        }
        
        private function _reset( i_event:MouseEvent = null ):void {
            var i:uint;
            for ( i=0; i<_NUM_BALLS; i++ ) _balls[i].position = i * _POSITION_OFFSET * 1 + ( Math.random() * _POSITION_OFFSET * 2 );
            addEventListener( Event.ENTER_FRAME, _onEnterFrame );
        }

        
        
        private function _onEnterFrame( i_event:Event ):void {
            var i:uint;
            for ( i=0; i<_NUM_BALLS; i++ ) _balls[i].position += _POSITION_OFFSET;
            if ( _balls[0].position >= 1 ) i_event.target.removeEventListener( i_event.type, arguments.callee );
        }
    }
}

import flash.display.Sprite;
class Ball extends Sprite {
    
    private static const _MAX_Y:uint = 450;
    private static const _MIN_SCALE:Number = 0.2;
    private static const _RANGE_X:uint = 60;
    private static const _MIN_RANGE_SCALE:Number = 0.5;
    private static const _FREQUENCY:Number = 3.5;
    private static const _FREQUENCY_RADIAN:Number = Math.PI * 2 * _FREQUENCY;
    
    private var _rangeX:Number;
    private var _frequency:Number;
    private var _position:Number;
    public function Ball() {
        _frequency = _FREQUENCY_RADIAN * Math.random() * 0.5 + _FREQUENCY_RADIAN * 0.5;
        _rangeX = _RANGE_X * Math.random() * 0.5 + _RANGE_X * 0.5;
        graphics.beginFill( 0x336699, 0.5 );
        graphics.drawCircle( 0, 0, 15 );
        position = 0;
    }
    
    public function get position():Number { return _position; }
    public function set position( i_value:Number ):void {
        _position = i_value;
        if ( _position > 1 ) _position = 1;
        else if ( _position < 0 ) _position = 0;
        
        if ( _position < 0.3 ) alpha = _position / 0.3;
        else if ( _position > 0.7 ) alpha = ( 1 - _position ) / 0.3;
        else alpha = 1;
        
        y = _MAX_Y * _position;
        x = Math.sin( _position * ( _frequency ) ) * ( _rangeX * ( 1 - _position * _MIN_RANGE_SCALE ) );
        scaleX = scaleY = 1 - _position * _MIN_SCALE;
    }
}
