/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cIhe
 */

package {
  import flash.display.Sprite;
  import flash.events.MouseEvent;

  public class ch21ex5 extends Sprite {
    public function ch21ex5() {
      var a:NestedCircles = new NestedCircles(true, 0xff0000); //use ROLL_OVER
      var b:NestedCircles = new NestedCircles(false, 0x0000ff); //user MOUSE_OVER
      a.x = 100;
      b.x = 250;
      a.y = b.y = 150;
      addChild(a); addChild(b);
    }
  }
}
import flash.display.*;
import flash.events.MouseEvent;
class NestedCircles extends Sprite {
  public var child:NestedCircles;
  protected var stroke:Shape;
  public function NestedCircles(useRoll:Boolean, color:uint = 0, size:Number = 60, isChild:Boolean = false) {
    graphics.beginFill(color, 0.25);
    graphics.drawCircle(0, 0, size);
    graphics.endFill();
    stroke = new Shape();
    addChild(stroke);
    stroke.graphics.lineStyle(5, 0xffff00);
    stroke.graphics.drawCircle(0, 0, size);
    stroke.visible = false;
    if (useRoll) {
      addEventListener(MouseEvent.ROLL_OVER, handler);
      addEventListener(MouseEvent.ROLL_OUT, handler);
    } else {
      addEventListener(MouseEvent.MOUSE_OVER, handler);
      addEventListener(MouseEvent.MOUSE_OUT, handler);    
    }
    if (!isChild) {
      child = new NestedCircles(useRoll, color, size/2, true);
      addChild(child);
      child.y = -size;
    }
  }
  protected function handler(event:MouseEvent):void {
    switch (event.type) {
      case MouseEvent.MOUSE_OUT:
      case MouseEvent.ROLL_OUT:
        stroke.visible = false;
        event.stopPropagation();
        break;
      case MouseEvent.MOUSE_OVER:
      case MouseEvent.ROLL_OVER:
        stroke.visible = true;
        event.stopPropagation();
        break;
    }
  }
}