/**
 * Copyright 1000ch ( http://wonderfl.net/user/1000ch )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cHzoZ
 */

// forked from clockmaker's ColorTransform Sample
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class Main extends Sprite {
        
        private var bmd:BitmapData;
        
        public function Main() {
            // BitmapDataを用意
            bmd = new BitmapData(465, 465);
            addChild(new Bitmap(bmd)); // 画面に表示
            
            // エンターフレームイベントを登録
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
    
        private function enterFrameHandler(e:Event):void{
            // ColorTransformの適用範囲を設定
            var rect:Rectangle = bmd.rect;
            
            // ColorTransformオブジェクトを生成
            // 引数の順番は赤、緑、青、透明度の順。それぞれを微妙にずらすと効果が適用される。
            // 透明度を1未満に設定することで徐々に透過するようなエフェクトを得ることができる。
            var ct:ColorTransform = new ColorTransform(1.5, 0.5, 0.9, 0.9);
            
            // ColorTransformを適用
            bmd.colorTransform(rect, ct);
            
            // 任意の画面描画(ランダムな座標に赤色の矩形を描画)
            var color:uint = 0x55FF6600;
            var fillR:Rectangle = new Rectangle(465*Math.random(), 465*Math.random(), 150, 150);
            bmd.fillRect(fillR, color);
        }
    }
}