/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cGuY
 */

/*
オタマジャクシのような謎の生物(？)が、仲間とぶつかると避けたり、
仲間に連いて行ったり、たまに仲間同士でスリスリしたりします。

マウスダウンで1匹追加。
マウスをしばらくダウンしたままにすると集まってきます。

あまり増やし過ぎるとダマになるので…
いいアイデアが浮かんだら改良します。
*/

package  {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.filters.BlurFilter;
    import net.hires.debug.Stats;
 
    [SWF(width="465", height="465", frameRate="60")] 
    
    public class Main extends Sprite{
        
        private static const DOT_NUM:uint = 30
        private var _container:Sprite = new Sprite()
        private var _bmd:BitmapData
        private var _bm:Bitmap
        private var _dotList:Vector.<Dot> = new Vector.<Dot>()
        private var _isClicked:Boolean

        public function Main() {
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF)
            _bm = new Bitmap(_bmd, "auto", true)
            addChild(_bm)
            //
            for(var i:int; i<DOT_NUM; i++){
                addDot(int(Math.random() * stage.stageWidth), int(Math.random() * stage.stageHeight))
            }
            addEventListener(Event.ENTER_FRAME, update)
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onDown)
            stage.addEventListener(MouseEvent.MOUSE_UP, onUp)
            //addChild(new Stats());
        }
        
        private function addDot($startX:Number, $startY:Number):void{
            var dot:Dot = new Dot(stage.stageWidth, stage.stageHeight)
            dot.x = $startX
            dot.y = $startY
            _container.addChild(dot)
            _dotList.push(dot)
        }
        
        private function update(e:Event):void{
            if(!_isClicked){
                for(var i:int; i<_dotList.length; i++){
                    hitCheck(_bmd, _dotList[i])
                }
            }
            //
            _bmd.lock()
            _bmd.colorTransform(_bmd.rect, new ColorTransform(1.07, 1.07, 1.07, 1, 0, 0, 0, 0));
            _bmd.draw(_container)
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(0,0), new BlurFilter(2,2,1))
            _bmd.unlock()
        }
        
        private function onDown(e:MouseEvent):void{
            _isClicked = true
            if(_dotList.length < 100) addDot(mouseX, mouseY)
            for(var i:int; i<_dotList.length; i++){
                _dotList[i]._p.x = mouseX
                _dotList[i]._p.y = mouseY
            }
        }
        
        private function onUp(e:MouseEvent):void{
            _isClicked = false
        }
        
        private function hitCheck(bmd:BitmapData, dot:Dot):void{
            var n:int
            for(var i:int=-10; i<10; i++){
                for(var j:int=-10; j<10; j++){
                    if(bmd.getPixel(dot.x+j, dot.y+i) != 0xFFFFFF){
                        n++
                    }
                }
            }
            if(n > 250 && n < 280){
                dot.stopTween()
            }
        }

    }
}

//class Dot
import flash.display.Sprite;
import flash.geom.Point;
import fl.motion.easing.*;
import com.flashdynamix.motion.*;

class Dot extends Sprite{
    
    private var _w:int
    private var _h:int
    public var _p:Point
    private var _speed:Number
    private var _tween:TweensyGroup
    
    public function Dot(w:int, h:int){
        _w = w
        _h = h
        _p = new Point(int(Math.random() * (_w * 1.2) - (_w * .1)),int(Math.random() * (_h * 1.2) - (_h * .1)));
        //
        var r:int = int(Math.random() * 8 + 88) << 16
        var g:int = int(Math.random() * 8 + 88) << 8
        var b:int = int(Math.random() * 8 + 88)
        var col:int = r + g + b
        graphics.beginFill(col)
        graphics.drawCircle(0,0,4)
        graphics.endFill()
        //
        tween(Math.random() * 5 + 3, _p.x, _p.y)
    }
    
    private function tween(time:Number, xPos:Number, yPos:Number=0, delay:Number=0):void {
        _p = new Point(int(Math.random() * (_w * 1.2) - (_w * .1)),int(Math.random() * (_h * 1.2) - (_h * .1)));
        _tween = new TweensyGroup();
        _tween.to(this, {x:xPos, y:yPos}, time, Linear.easeOut, delay);
        _tween.onComplete = tweenComplete;
        function tweenComplete():void {
            _tween.dispose();
            _tween = null;
            tween(Math.random() * 5 + 3, _p.x, _p.y)        
        }
    }

    public function stopTween():void{
        _tween.stop(this)
        _tween.dispose();
        _tween = null;
        tween(Math.random() * 1 + 2, _p.x, _p.y)
    }
}