/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cGTb
 */

package  
{
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.ByteArray;
    import flash.utils.getTimer;
    
    public class FlashTest extends Sprite
    {
        private const moja: String = "moja";
        
        public function FlashTest() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            var sp: Sprite = new Sprite();
            addChild(sp);
            var bmd: BitmapData = new BitmapData(100, 100, false);
            var baseXY: Number = 32;
            bmd.perlinNoise(baseXY, baseXY, 2, 0xFFFF * Math.random(), true, true, Math.random()*7+1);
            var bmdA: BitmapData = new BitmapData(bmd.width, bmd.height, false);
            var bmdB: BitmapData = new BitmapData(bmd.width, bmd.height, false);
            sp.addChild(new Bitmap(bmd, "auto", true));
            var c: uint, rgb: uint, r: uint, g: uint, b: uint, t: int;
            
            // 拡大縮小による平均
            t = getTimer();
            bmdA.draw(bmd, new Matrix(1/bmd.width, 0, 0, 1/bmd.height), null, null, null, true);
            bmdA.draw(bmdA, new Matrix(bmd.width, 0, 0, bmd.height));
            c = bmdA.getPixel(10, 10);
            new Label(sp, 0, 210, c.toString(0x10).toUpperCase() + "\n" + (getTimer() - t) + " ms");
            // 全ピクセル走査による平均
            t = getTimer();
            var bytes: ByteArray = bmd.getPixels(bmd.rect);
            bytes.position = 0;
            while (bytes.bytesAvailable)
            {
                rgb = bytes.readUnsignedInt() & 0xFFFFFF;
                r += (rgb >> 0x10) & 0xFF;
                g += (rgb >> 0x08) & 0xFF;
                b += (rgb >> 0x00) & 0xFF;
            }
            var cnt: uint = bmd.width * bmd.height;
            r = r / cnt;
            g = g / cnt;
            b = b / cnt;
            c = (r << 0x10) | (g << 0x08) | (b << 0x00);
            bmdB.fillRect(bmdB.rect, c);
            new Label(sp, 110, 210, c.toString(0x10).toUpperCase() + "\n" + (getTimer() - t) + " ms");
            var bmpA: Bitmap = new Bitmap(bmdA, "auto", true);
            var bmpB: Bitmap = new Bitmap(bmdB, "auto", true);
            bmpB.x = 105;
            bmpA.y = bmpB.y = 105;
            sp.addChild(bmpA);
            sp.addChild(bmpB);
            sp.x = 100;
            sp.y = 100;
            
        }
        
    }
}