/**
 * Copyright smallwind1912 ( http://wonderfl.net/user/smallwind1912 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cGC8
 */

// forked from cpu_t's rings graphics
package {
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import net.hires.debug.Stats;
    [SWF(width = "465", height = "465", frameRate = "60")]
    public class FlashTest extends Sprite {
        private var _canvas:BitmapData;
        private var _drawDisplay:Sprite;
        private var _count:Number = 0;
        private var _blur:BlurFilter;
        private var _ct:ColorTransform;
        public function FlashTest() {
            // write as3 code here..
            stage.addChild(new Stats());
            _canvas = new BitmapData(WIDTH,HEIGHT,false,0);
            addChild(new Bitmap(_canvas));
            _drawDisplay = new Sprite();
            _blur = new BlurFilter();
            _ct = new ColorTransform();
            _ct.alphaMultiplier = 0.9;
            
            addEventListener(Event.ENTER_FRAME, onUpdate);
        }
        
        private function onUpdate(e:Event):void
        {
            if(++_count % 3 == 0)
            {
                _count = 0;
                var circle:Circle = new Circle();
                _drawDisplay.addChild(circle);
            }
            for(var i:int = 0; i < _drawDisplay.numChildren; i++)
            {
                circle = _drawDisplay.getChildAt(i) as Circle;
                if(circle)
                {
                    circle.update();
                    if(circle.isDead) _drawDisplay.removeChild(circle);
                }
            }
            _canvas.lock();
            //_canvas.fillRect(_canvas.rect, 0);
            _canvas.applyFilter(_canvas, _canvas.rect, _canvas.rect.topLeft, _blur);
            _canvas.colorTransform(_canvas.rect, _ct);
            _canvas.draw(_drawDisplay);
            _canvas.unlock();
        }
    }
}
import flash.geom.Rectangle;
var WIDTH:Number = 465;
var HEIGHT:Number = 465;
import flash.display.Shape;

class Circle extends Shape
{
    private var radiusA:Number = 0;
    private var radiusB:Number = 0;
    private var vx:Number = 0;
    private var vy:Number = 0;
    private var ax:Number = 0;
    private var ay:Number = 0;
    private var vrA:Number = 0;
    private var vrB:Number = 0;
    public var isDead:Boolean = false;
    public function Circle()
    {
        alpha = Math.random() * 0.5 + 0.5;
        x = Math.random() * WIDTH;
        y = Math.random() * HEIGHT;
    }
    public function update():void
    {
        //alpha -= Math.random() * 0.00001;
        if(alpha <= 0) isDead = true;
        ax += (Math.random() - 0.5) * 0.01;
        ay += (Math.random() - 0.5) * 0.01;
        vx += ax;
        vy += ay;
        x += vx;
        y += vy;
        vrA += (Math.random() - 0.5) * 0.1;
        vrB += (Math.random() - 0.5) * 0.01;
        radiusA += vrA;
        radiusB += vrB;
        graphics.clear();
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0, 0, radiusA);
        graphics.drawCircle(0, 0, radiusA - radiusB);
        graphics.endFill();
        var rect:Rectangle = getBounds(parent);
        if((rect.right < 0 || rect.left >= WIDTH) && (rect.bottom < 0 || rect.top >= HEIGHT))
        {
            isDead = true;
        }
    }
}