/**
 * Copyright ultranoir ( http://wonderfl.net/user/ultranoir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cFCyG
 */

// forked from mousepancyo's HSV Color Particles
package {
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.utils.Timer;
    import fl.motion.easing.*;
    
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.core.geom.renderables.Particle;
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.materials.special.ParticleMaterial;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.view.Viewport3D;
    import com.flashdynamix.motion.*;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="30")]
    
    public class Main extends Sprite {
        private const W:int = 465
        private const H:int = 465
        
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _viewport:Viewport3D;
        private var _render:BasicRenderEngine;
        private var _rootNode:DisplayObject3D;
        private var _bmpEffect:BitmapEffectLayer;
        
        private var _changeFLg:Boolean;
           private var _timer:Timer;
        
        private var _materials:Particles;
        private var _verticesList:Array = []
        private var _particleList:Array = []
        
        private var _tween:TweensyGroup
        
        public function Main():void {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, W, H);
            graphics.endFill();
            //
            addSpace();
        }
        
        private function addSpace():void {
            _scene = new Scene3D();
            _viewport = new Viewport3D(0, 0, true, false);
            _rootNode = new DisplayObject3D();
            //
            _camera = new Camera3D();
            _camera.z = -_camera.focus * _camera.zoom * .2;
            //
            _render = new BasicRenderEngine();
            //
            addVertices()
            //
            addChild(_viewport);
            _scene.addChild(_rootNode);
            //
            _bmpEffect = new BitmapEffectLayer(_viewport, W, H, true, 0, "clear_pre", false, false );
            _bmpEffect.addEffect(new BitmapLayerEffect(new BlurFilter(8, 8, 3), false));
            _bmpEffect.drawCommand.blendMode = "screen"
            _bmpEffect.drawCommand.colorTransform = new ColorTransform(1, 1, 1, .3, 0, 0, 0, 0);
            _viewport.containerSprite.addLayer(_bmpEffect);
            _bmpEffect.addDisplayObject3D(_materials);
            //
            _changeFLg = true;
            _rootNode.addChild(_materials);
            //
            for (var i:int = 0; i < _particleList.length; i++) {
                var gx:Number = _verticesList[i].x;
                var gy:Number = _verticesList[i].y;
                var gz:Number = _verticesList[i].z;
                tween(_particleList[i], 3, gx, gy, gz, i * .003);
            }
            //
            addEventListener(Event.ENTER_FRAME, update);
            stage.addEventListener(MouseEvent.CLICK, stageClick);
        }
        
        private function addVertices():void{
            _materials = new Particles();
            var n:int;
            var i:int;
            var j:int;
            while(n < 10){
                i = 0;
                while(i < 10){
                    j = 0;
                    while(j < 20){
                        var h:Number = (360 / 20) * j;
                        var s:Number = i * .1;
                        var v:Number = n * .1;
                        var rgb:int = ColorUtil.hsvToRgb(h, s, v);
                        //
                        var vertices:Vertices = new Vertices();
                        vertices.y = v * 50 - 25;
                        vertices.x = Math.cos( h * Math.PI / 180 ) * (s * 30);
                        vertices.z = Math.sin( h * Math.PI / 180 ) * (s * 30);
                        vertices.color = rgb;
                        //
                        _verticesList.push(vertices);
                        //
                        var mat:ParticleMaterial = new ParticleMaterial(rgb, 1, 1, 1);
                        var particle:Particle = new Particle(mat, 1, Math.random() * 300 - 150, Math.random()* 300 - 150, Math.random()* 300 - 150);
                        _materials.addParticle(particle);
                        _particleList.push(particle);
                        //
                        j++;
                    }
                    i++;
                }
                n++;
            }
        }
        
        private function update(e:Event):void{
           _render.renderScene(_scene, _camera, _viewport);
           _rootNode.rotationY += .3;
           _rootNode.rotationX -= .1;
           _rootNode.rotationZ -= .1;
        }
        
        private function stageClick(e:MouseEvent):void{
            if(_changeFLg){
                for (var i:int = 0; i < _materials.geometry.vertices.length; i++) {
                    tween(_materials.geometry.vertices[i], 3, Math.random() * 150 - 75, Math.random()* 150 - 75, Math.random()* 150 - 75);
                }
                _changeFLg = false;
            }else{
                for (i = 0; i < _particleList.length; i++) {
                    var gx:Number = _verticesList[i].x;
                    var gy:Number = _verticesList[i].y;
                    var gz:Number = _verticesList[i].z;
                    tween(_particleList[i], 5, gx, gy, gz, i*.001);
                }
                _changeFLg = true;
            }
        }
        
        //tween
        public function tween(target:Object, time:Number, xPos:Number, yPos:Number=0, zPos:Number=0, delay:Number=0):void{
            var tween:TweensyGroup = new TweensyGroup();
            tween.to(target, {x:xPos, y:yPos, z:zPos}, time, Exponential.easeInOut, delay);
            tween.onComplete = memoryClear;
            function memoryClear():void{
                tween.dispose();
                tween = null;
            }
        }
    }
}

//class Vertices
class Vertices{
    public var x:Number;
    public var y:Number;
    public var z:Number;
    public var color:int;
}


// ColorUtil
class ColorUtil {

    // HSV > RGB
    public static function hsvToRgb(h:Number, s:Number, v:Number):Number {
        var cv:Number = Math.round(v * 255);
        var r:Number = cv;
        var g:Number = cv;
        var b:Number = cv;
        if (s > 0) {
            var i:Number = Math.floor(h / 60);
            var f:Number = h / 60 - i;
            var m:Number = Math.round(v * (1 - s) * 255);
            var n:Number = Math.round(v * (1 - s * f) * 255);
            var k:Number = Math.round(v * (1 - s * (1 - f)) * 255);
            switch (i) {
                case 0 :
                    g = k;
                    b = m;
                    break;
                case 1 :
                    r = n;
                    b = m;
                    break;
                case 2 :
                    r = m;
                    b = k;
                    break;
                case 3 :
                    r = m;
                    g = n;
                    break;
                case 4 :
                    r = k;
                    g = m;
                    break;
                case 5 :
                    g = m;
                    b = n;
                    break;
            }
        }
        return r << 16 | g << 8 | b;
    }

    // RGB > HSV
    public static function colorToHsv(color:Number):Object {
        var r:Number = color >> 16;
        var g:Number = (color >> 8) & 0xFF;
        var b:Number = color & 0xFF;
        var max:Number = Math.max(r,Math.max(g,b));
        var min:Number = Math.min(r,Math.min(g,b));
        var range:Number = max - min;
        var h:Number = 0;
        var s:Number = 0;
        var v:Number = max / 255;
        if (v > 0) {
            s = range / max;
            if (s > 0) {
                var cr:Number = (max - r) / range;
                var cg:Number = (max - g) / range;
                var cb:Number = (max - b) / range;
                if (r == max) {
                    h = cb - cg;
                } else if (g == max) {
                    h = 2 + cr - cb;
                } else {
                    h = 4 + cg - cr;
                }
                h *= 60;
                if (h<0) {
                    h+=360;
                }
            }
        }
        return {h:Math.round(h * 100) * 0.01, s:Math.round(s * 100), v:Math.round(v * 100)};
    }
}