/**
 * Copyright sacrifs ( http://wonderfl.net/user/sacrifs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cEzF
 */

//propertyIsEnumerableとfor..in
//
//憶測:
//カスタムクラスのプロパティはpropertyIsEnumerableの値を変更できないため列挙できない？
//prototypeに同名の変数を定義すると、propertyIsEnumerableが自動的に設定される？
//
//
//
package {
    import flash.text.TextField;
    import flash.display.Sprite;
    public class forIn extends Sprite {
        
        private const TF_X:int = 30;
        private const TF_Y:int = 30;
        private const TF_W:int = 200;
        private const TF_H:int = 300;
        
        private const TF_X2:int = 235;
        
        private const LOOP:int = 3;
        
        private var _listCustom:Array;
        private var _listObject:Array;
        
        private var _tf:TextField;
        private var _tf2:TextField;
        
        public function forIn() {
            init();
        }
        
        /**
         * init
         */
        private function init():void{
            initText();
            setData();
            showData(1);
            showDataPrototype(2);
        }
        
        /**
         * ログ用テキスト
         */
        private function initText():void{
            _tf = new TextField();
            _tf2 = new TextField();
            addChild(_tf);
            addChild(_tf2);
            setTFPos(TF_X, TF_Y, TF_W, TF_H, _tf);
            setTFPos(TF_X2, TF_Y, TF_W, TF_H, _tf2);
            
        }
        
        /**
         * ログ用テキストの位置
         */
        private function setTFPos(x:int, y:int, w:int, h:int, tf:TextField):void{
            tf.x = x;
            tf.y = y;
            tf.width = w;
            tf.height = h;
            tf.border = true;
        }

        /**
         * データのセット
         */
        private function setData():void{
            _listCustom = [];
            _listObject = [];
            for(var i:uint = 0; i < LOOP; i++){
                var id:String = 'id' + String(i+1);
                var name:String = 'name' + String(i+1);
                var tO:TestObj = new TestObj();
                var obj:Object = new Object();
                tO.id = obj.id = id;
                tO.name = obj.name = name;
                
                _listCustom.push(tO);
                _listObject.push(obj);
            }
        }
        
        /**
         * 出力
         */
        private function showData(logNum:int):void{
            for(var i:uint = 0; i < LOOP; i++){
                var tO:TestObj = _listCustom[i];
                var obj:Object = _listObject[i];
                for(var propC:String in tO){
                    log(tO[propC], logNum);
                }
                
                log('* * *', logNum);
                
                for(var propO:String in obj){
                    log(obj[propO], logNum);
                }
                log('- - - - -', logNum);

            }

        }
        
        /**
         * 変数名と同じprototypeを定義するとどうなるか？
         */
        private function showDataPrototype(logNum:int):void{
            //TestObj.prototype.setPropertyIsEnumerable('id', true);//効果なし
            TestObj.prototype.id = TestObj.prototype.name = '';//コメントアウトで列挙されず
            //TestObj.prototype.setPropertyIsEnumerable('id', false);//効果あり
            
            showData(logNum);
            
        }

        /**
         * ログ
         */
        private function log(str:String, logNum:int):void{
            if(logNum == 1){
                _tf.appendText(str + "\n");
            }
            else{
                _tf2.appendText(str + "\n");
            }

        }

    }
}

class TestObj{
    public var id:String;
    public var name:String;


}