/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cDjd
 */

// forked from spanvega's flash on 2011-5-22
package
{
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;

    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    import flash.filters.BlurFilter;

    import flash.text.TextField;

    import flash.net.URLRequest;
    import flash.utils.ByteArray;

    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;

    import flash.media.Sound;
    import flash.media.ID3Info;
    import flash.media.SoundMixer;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;


    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '25') ]

    public class SPECTRUM_CURVE extends Sprite
    {
        private var track : String = 'http://dhai-haif.rhcloud.com/lxpp/music/jynhznl.mp3';
        private var sound_length : String = '0:00';

        private var sound_channel : SoundChannel;
        private var sound : Sound;

        private var channel_space : Number;
        private var channel_height : uint;

        private var bytes : ByteArray = new ByteArray ();
        private var count : Number = 0;
        private var infos : TextField;
        private var plays : TextField;
        private var lines : Bitmap;
        private var waves : Bitmap;


        public function SPECTRUM_CURVE ()
        {
            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        };


        private function init (e : Event = null) : void
        {
            var SH : uint = stage.stageHeight;
            var SW : uint = stage.stageWidth;

            stage.scaleMode = 'noScale';

            channel_height = Math.round (SH / 3);
            channel_space  = SW / 256;

            //

            var matrix : Matrix = new Matrix ();
            matrix.createGradientBox (SW, SH, 90 * (Math.PI /180), 0, -35);

            var background : Shape = new Shape ();
            background.graphics.beginGradientFill('linear', [0x000000, 0xFFFFFF], [1, 1], [127, 190], matrix);
            background.graphics.drawRect (0, 0, SW, SH);
            background.graphics.endFill ();

            addChild (background);

            //

            infos = new TextField ();
            infos.autoSize = 'left';
            infos.x = 5;
            infos.y = SH - 20;
            infos.htmlText = '<font size=\'10\'>[ Buffering ... ]</font>';

            addChild (infos);

            //

            plays = new TextField ();
            plays.autoSize = 'right';
            plays.x = SW - 10;
            plays.y = 5;

            addChild (plays);

            //

            waves = new Bitmap ();
            waves.bitmapData = new BitmapData
            (
                stage.stageWidth, channel_height * 2, true, 0
            );
        
            addChild (waves);

            //
    
            lines = new Bitmap ();
            lines.x = channel_space; // MATRIX TRANSLATE channel_space

            addChild (lines);

            //

            sound = new Sound ();

            sound.addEventListener (Event.ID3, onID3);
            sound.addEventListener (IOErrorEvent.IO_ERROR, onIOError);
            sound.addEventListener (SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
            sound.load
            (
                new URLRequest (track),
                new SoundLoaderContext (0, true)
            );

            sound_channel = sound.play ();
            sound_channel.addEventListener (Event.SOUND_COMPLETE, onSoundComplete);

            addEventListener (Event.ENTER_FRAME, onEnterFrame);
        }

        private function onEnterFrame (e : Event) : void
        {
            SoundMixer.computeSpectrum (bytes, false, 0);

            plays.htmlText = '<font size=\'10\' color=\'#FFFFFF\'>[ ' + onDuration (sound_channel.position) + ' | ' + sound_length + ' ]</font>';

            //

            var v : Number;

            var line : Shape = new Shape ();
            var wave : Shape = new Shape ();

            line.graphics.lineStyle (1, 0xFFFFFF);
            wave.graphics.lineStyle (3, onColor());

            // --o COMPUTE LEFT CHANNEL ONLY (1|2 VALUE)

            for (var i : int = 0; i < 256; i+= 2)
            {
                v = bytes.readFloat () * channel_height / 2;

                // --o LINES

                line.graphics.moveTo
                (
                    i * channel_space,
                    2 * channel_height
                );
                line.graphics.curveTo
                (
                    i * channel_space + (v * 2),
                    channel_height * 1.5,
                    i * channel_space,
                    channel_height + v
                );

                line.filters = [new BlurFilter (v/2, 10)];

                // --o WAVES

                wave.graphics.moveTo
                (
                    i * channel_space,
                    v + channel_height
                );
                wave.graphics.lineTo
                (
                    i * channel_space,
                    v + channel_height - 1
                );

                wave.filters = [new BlurFilter (10, -v/2)];

                bytes.position += 4;
            }

            //

            var rect_line : Rectangle = line.getRect (this);

            var data_line : BitmapData = new BitmapData (rect_line.width, rect_line.height, true, 0);
            data_line.draw
            (
                line, new Matrix (1, 0, 0, 1, 0, -rect_line.y)
            );

            lines.bitmapData = data_line;
            lines.y = rect_line.y;

            //

            if (sound_channel.position != 0) // TITRE PAS DEBUTE + CONDITION TITRE FINI
            {
                var rect_wave : Rectangle = wave.getRect (this);

                var color_trans : ColorTransform = new ColorTransform (1, 1, 1, 0.75);
                
                waves.bitmapData.colorTransform (waves.getRect (this), color_trans);
                waves.bitmapData.scroll (0, -5);
                // waves.bitmapData.copyPixels (waves.bitmapData, waves.getRect (this), new Point (0, -5), null, null, false);

                waves.bitmapData.draw
                (
                    wave, new Matrix (1, 0, 0, 1, 0, -rect_wave.y + channel_height - 25)
                );
            }
        }

        private function onColor () : Number
        {
            var n : Number = (360 * (count += .5/ 100)) * (Math.PI / 180);
 
            var r : Number = Math.cos (n)                   * 127 + 128 << 16;
            var v : Number = Math.cos (n + 2 * Math.PI / 3) * 127 + 128 << 8;
            var b : Number = Math.cos (n + 4 * Math.PI / 3) * 127 + 128;

            return r | v | b;
        }

        private function onID3 (e : Event) : void
        {    
            sound.removeEventListener (Event.ID3, onID3);
    
            sound_length = onDuration (sound.id3.TLEN);

            infos.htmlText = '<font size=\'10\'>[ ' + sound.id3.TPE1 + ' | ' + sound.id3.TIT2 + ' | ' + sound.id3.TBPM + ' BPM ]</font>';
        }

        private function onDuration (n : uint) : String
        {
            var m : uint = Math.floor(n / 1000 / 60);
            var s : uint = Math.floor(n / 1000) % 60;

            return m + ':' + (s < 10 ? '0' + s : s);
        }

        private function onSoundComplete (e : Event) : void
        {
            removeEventListener (Event.ENTER_FRAME, onEnterFrame);
        }

        private function onIOError (e : IOErrorEvent) : void {}

        private function onSecurityError (e : SecurityErrorEvent) : void {}
    }
}