/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cDKX
 */

// forked from nemu90kWw's まるをしきつめる
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    
    public class FlashTest extends Sprite 
    {
        private var 
        num:int = 300,
        circles:Vector.<Circle> = new Vector.<Circle>(num, true);
        
        public function FlashTest() {
            graphics.beginFill(0xD0D0FF);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            stage.frameRate = 120;
            
            var i:int = -1;
            while(++i < num)
            {
                circles[i] = new Circle(465/2+Math.random()*100-50, 
                    465/2+Math.random()*100-50, 
                    Math.random()*Math.random()*50);
                this.addChild(circles[i]);
            }

            stage.addEventListener(MouseEvent.CLICK, onClick);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            addChild(new Stats());
        }
        
        private function onClick(e:MouseEvent):void 
        {
            var 
            i:int = -1,
            circle:Circle;
            while(++i < num)
            {
                circle = circles[i];
                circle.x = mouseX + Math.random()*100 - 50;
                circle.y = mouseY + Math.random()*100 - 50;
            }
        }
        
        private function onEnterFrame(e:Event):void 
        {
            var 
            i:int = -1, k:int, l:int = num -1,
            c1:Circle, c2:Circle,
            dx:Number, dy:Number, d:Number,
            dx2:Number, dy2:Number, d2:Number,
            angle:Number, multiplier:Number, cos:Number, sin:Number;
            
            while(++i < l)
            {
                k = i;
                while(++k < num)
                {
                    c1 = circles[i];
                    c2 = circles[k];
                    dx = dx2 = c1.x - c2.x;
                    dy = dy2 = c1.y - c2.y;
                    d2 = (dx2*=dx2) + (dy2*=dy2);
                    d = Math.sqrt(d2);
                    if(d < c1.size+c2.size)
                    {
                        angle = Math.atan2(dy, dx); // atan2 dy, dx
                        cos = Math.cos(angle);
                        sin = Math.sin(angle);
                        multiplier = (c1.size + c2.size - d) * .5;
                        c1.x += cos * multiplier;
                        c1.y += sin * multiplier;
                        c2.x -= cos * multiplier;
                        c2.y -= sin * multiplier;
                    }
                }
            }
        }
    }
}
import flash.display.*;

class Circle extends Shape 
{
    public var 
    size:Number;
    function Circle(x:Number, y:Number, size:Number)
    {
        this.x = x;
        this.y = y;
        this.size = size;
        graphics.beginFill(0xFFA000);
        graphics.lineStyle(2, 0x402000);
        graphics.drawCircle(0, 0, size);
        graphics.endFill();
        this.cacheAsBitmap = true;
    }
}
