/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cDDd
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	
	[SWF(backgroundColor="0x000000")]
	public class Main extends Sprite{
		private var _red:Sample4;
		private var _blue:Sample4;
		private var _bitmapData:BitmapData;
		public function Main():void {
			_red = new Sample4(-50);
			this.addChild(_red);
			_blue = new Sample4(50);
			this.addChild(_blue);
			
			_bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
			addChild(new Bitmap(_bitmapData))
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			_red.loop(null);
			_blue.loop(null);
			
			_bitmapData.lock();
			_bitmapData.fillRect(new Rectangle(0,0,stage.stageWidth,stage.stageHeight), 0x000000);
			_bitmapData.draw(_red, null,new ColorTransform(1,0,0,1,0,0,0,0));
			_bitmapData.draw(_blue, null,new ColorTransform(0,1,1,1,0,0,0,0), "add");
			_bitmapData.unlock();
		}
	}
}

import flash.events.*;
import org.papervision3d.materials.*;
import org.papervision3d.objects.primitives.*;
import org.papervision3d.view.*;

class Sample4 extends BasicView {
	public function Sample4(dX:Number):void {
		// マテリアルを作成
		var material:WireframeMaterial = new WireframeMaterial(0xFFFFFF);
		
		// 3Dオブジェクトを作成
		var sphere1:Sphere = new Sphere(material, 300, 10, 10);
		var sphere2:Sphere = new Sphere(material, 300, 10, 10);
		
		// 座標を設定
		sphere1.x =  500-dX/3;
		sphere2.x = -500-dX/3;
		camera.x = dX;
		
		// 3Dシーンに追加して、表示させる
		scene.addChild(sphere1);
		scene.addChild(sphere2);
		
		// レンダリングを開始
		startRendering();
		
		// エンターフレームを設定
		//addEventListener(Event.ENTER_FRAME, loop);
	}
	
	// エンターフレーム
	public function loop(e:Event):void {
		// カメラの位置を変える
		var rateX:Number = mouseX / stage.stageWidth;
		var targetX:Number = -5000 * (rateX - 0.5);
		camera.x += (targetX - camera.x) * 0.2;
		
		var rateY:Number = mouseY / stage.stageHeight;
		var targetY:Number = 5000 * (rateY - 0.5);
		camera.y += (targetY - camera.y) * 0.2;
	}
}
