/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cC1p
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
          tmap = new xTmap();
          tmap.initEmpty(32,24);  
          tmap.setRect2(0,0,32,24,1);
          tmap.setRect2(1,1, 30,22, 0);  
        
          worldw = tmap.mw * tmap.cw;
          worldh = tmap.mh * tmap.ch;
        
          var i:int;
          for (i=0;i<32; i++)
          {
            tmap.setRect2(Math.random()*30,Math.random()*20,4,1, 1);  
          }//nexti  
            
          stage.addEventListener(Event.ENTER_FRAME, onEnter);  
        }//ctor
        
        public var tmap:xTmap;    
        public var worldw:Number = 320;
        public var worldh:Number = 240;    
        public var camx:Number = 0;
        public var camy:Number = 0;
        public var wmx:Number = 0;
        public var wmy:Number = 0;
        
        
        public function onEnter(e:Event):void
        {
            var mx:Number; var my:Number;
            var kx:Number; var ky:Number;
            
            kx = worldw/460; ky = worldh/460;
            mx = stage.mouseX; my = stage.mouseY;
            camx = (kx * mx)-230; camy = (ky * my)-230;
            if (camx<0) {camx=0;} if (camx>worldw-465){camx=worldw-465;}
            if (camy<0) {camy=0;} if (camy>worldh-465){camy=worldh-465;}
        
            wmx = camx + mx; wmy = camy + my;
            
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            tmap.drawGrid(graphics, camx, camy);            
            
            graphics.drawCircle(wmx-camx,wmy-camy,8);          
            
            var ax:Number; var ay:Number;
            ax = wmx; ay = getHeight(wmx, wmy);
            ay = Math.floor(ay/tmap.ch)*tmap.ch;
            graphics.drawCircle(ax-camx,ay-camy,8);
            
              
        }//onenter
        
        public function getHeight(ax:Number, ay:Number):Number
        {
          var i:int;
          for (i=0;i<64;i+=1)
          { if (tmap.getTile(ax/tmap.cw, ay/tmap.ch) > 0) { return ay;}  ay += 8;  }
          return -1;  
        }//geth
        
        
    }//classend
}
import flash.display.Graphics;

internal class xTmap
{   
    public var vecGrid:Vector.<int>;
    public var mw:int = 0;         public var mh:int = 0;
    public var cw:Number = 32;     public var ch:Number = 32;   
    public function initEmpty(aw:int, ah:int):void   
     { mw=aw; mh=ah; vecGrid = new Vector.<int>(aw*ah, false); }        
    public function setTile(ax:int, ay:int, t:int):void   
    { if (ax<0||ax>=mw||ay<0||ay>=mh) {return;} vecGrid[ay*mw+ax]=t; }    
    public function getTile(ax:int, ay:int):int   
     { if (ax<0||ax>=mw||ay<0||ay>=mh) {return -1;} return vecGrid[ay*mw+ax]; }
       
    public function drawGrid(g:Graphics, ax:Number, ay:Number, sw:Number=465, sh:Number=465):void
    { var sx:int;    var sy:int;    var ex:int;      var ey:int;
      var i:int;     var k:int;     var yt:int;      var t:int;    
      var dx:Number; var dy:Number;      
      sx = Math.floor(ax/cw);            sy = Math.floor(ay/ch);
      ex = sx + Math.ceil(sw/cw)+1;      ey = sy + Math.ceil(sh/ch)+1;    
      if (sy < 0) { sy = 0; }     if (sy >= mh) { return; }
      if (sx < 0) { sx = 0; }     if (sx >= mw) { return; }          
      if (ex < 0) { return; }     if (ex > mw) { ex = mw; }
      if (ey < 0) { return; }     if (ey > mh) { ey = mh; }     
       for ( i = sy; i < ey; i++)
       { yt = i * mw;
        for (k = sx; k < ex; k++)
         {  t = vecGrid[yt+k]; if (t <= 0) { continue; }
            dx = (k*cw)-ax;    dy = (i*ch)-ay;
            g.beginFill(0);  g.drawRect(dx, dy, 32,32); g.endFill();
         }//nextk
       }//nexti  
    }//drawgrid   
    
    public function setRect(ax:Number, ay:Number, aw:Number, ah:Number, t:int):void   
     { setRect2(ax/cw, ay/ch, aw/cw, ah/ch, t); }
   
    public function setRect2(ax:int, ay:int, aw:int, ah:int, t:int):void
      { var i:int;      var k:int;      var yt:int;
        var sx:int;      var sy:int;      var ex:int;      var ey:int;   
        if (ax+aw < 0) { return; }      if (ay+ah < 0) { return; }
        if (ax > mw) { return; }      if (ay > mh) { return; }
        sx = ax;      sy = ay;      ex = sx+aw;      ey = sy+ah;
        if (sx< 0) { sx = 0;}      if (sy<0) {  sy = 0;}
        if (ex > mw) { ex = mw;}   if (ey > mh) { ey = mh;}
        for (i = sy; i < ey; i++)
        { yt = i * mw; for (k = sx; k < ex; k++) {  vecGrid[yt+k] = t; } }
      }//setrect2
    
}//xtmap


