/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cBLj
 */

package {
    /**
     * Alternativa3D SpringCamera(Controller)
     * 
     * Alternativa3Dには実装されていない、SpringCameraControllerです。
     * 
     * ネタ元は、clockmakerさん著、papervision3D入門の
     * 「オブジェクトカメラに追従するカメラを使う」です。
     * 
     * Wonderfl内でも
     * http://wonderfl.net/code/377fb950a67300bf295d28010a9cd590ba7c0ad5
     * にてライブコーディングで作成されています。
     *
     * SpringCameraControllerクラスはAlternativa3DのWalkControllerを継承したクラスとなっていますが
     * 仕様はcross3Dプロジェクトに向けてpapervision3DのSpringCameraに準拠させてます。
     *
     */

    import alternativ5.engine3d.primitives.Box;
    import alternativ5.engine3d.primitives.Sphere;
    import alternativ5.engine3d.materials.FillMaterial;
    import alternativ5.engine3d.materials.WireMaterial;
    import alternativ5.engine3d.events.MouseEvent3D
    import alternativ5.types.Point3D;
    import alternativ5.utils.*;

    import flash.display.Sprite;
    import flash.display.BlendMode;
    import flash.utils.describeType;

    /**
     * Alternativa3D を簡単に扱うためのベーシックテンプレート
     * @author Yasu (clockmaker)
     */
    
    [SWF(width = 465, height = 465, frameRate = 60, backgroundColor=0x00000000)]
    public class SimpleDemo extends Sprite {


        public function SimpleDemo():void {
            // テンプレートを作成します
            var template:BasicTemplate = new BasicTemplate();
            addChild(template);


            // レールを作成する
            for(var i:int=0; i<100; i++) {
                var s:Sphere=new Sphere(100,4,2,false,false);
                s.cloneMaterialToAllSurfaces(new WireMaterial(0,0xFF0000,1,BlendMode.NORMAL));
                s.mobility=2
                template.scene.root.addChild(s);

                var angle:Number = (i / 100) * 360 * Math.PI / 180;
                s.x = Math.cos(angle * 1) * 3000;
                s.y = Math.sin(angle * 2) * 3000;                
                s.z = 0.3 * Math.sin(angle * 1) * 3000;
            }


            // 星
            for(i = 0; i<200; i++) {
                s = new Sphere(100,4,2,false,false);
                s.cloneMaterialToAllSurfaces(new WireMaterial(0,0x666666,1,BlendMode.NORMAL));
                s.mobility=1
                template.scene.root.addChild(s);

                s.x = 20000 * (Math.random() - 0.5);
                s.y = 20000 * (Math.random() - 0.5);
                s.z = 20000 * (Math.random() - 0.5);
            }


            // マーカー
            var ball:Sphere=new Sphere(100,4,2,false,false);
            ball.cloneMaterialToAllSurfaces(new WireMaterial(0,0xFFFFFF,1,BlendMode.NORMAL));
            ball.mobility=3
            template.scene.root.addChild(ball);


            // SpringCameraController
            var cameraContoller:SpringCameraController=new SpringCameraController(this,template.camera);
            cameraContoller.target=ball;

            template.camera.fov=100*Math.PI/180

            cameraContoller.mass = 30;    
            cameraContoller.damping = 30;            
            cameraContoller.stiffness = 1;            
            cameraContoller.positionOffset = new Point3D(0, 200, 0);
            cameraContoller.lookOffset = new Point3D(0, 0, 0);

            var rot:Number = 0;

            template.onPreRender = function():void {

                rot += 0.15;
                var angle:Number = (rot / 100) * 360 * Math.PI / 180;
                ball.x = Math.cos(angle * 1) * 3000;
                ball.y = Math.sin(angle * 2) * 3000;
                ball.z = 0.3 * Math.sin(angle * 1) * 3000 + 300;

                //SpringCameraの追従
                cameraContoller.move()
            }
        }


    }
}



import flash.display.DisplayObject;
import alternativ5.engine3d.controllers.WalkController;
import alternativ5.types.Matrix3D;
import alternativ5.types.Point3D;
import flash.utils.*;

//-------------------------------------------------------------------
//SpringCameraController
//-------------------------------------------------------------------
class SpringCameraController extends WalkController{
    
    private var _camTarget:Object3D
    private var _zrot:Number = 0;

    public var mass:Number = 40;
    public var damping:Number = 4;
    public var stiffness:Number = 1;
    public var positionOffset:Point3D = new Point3D(0, -50, 5);
    public var lookOffset:Point3D = new Point3D(0, 10, 2);


    public function SpringCameraController(eventSourceObject:DisplayObject, object:Object3D = null) {
        super(eventSourceObject,object)
    }

    public function set target(t:Object3D):void {
        _camTarget=t
    }

    public function get target():Object3D {
        return _camTarget;
    }

    public function set zrot(n:Number):void {
        _zrot = n;
        if(_zrot < 0.001) n = 0;
    }

    public function get zrot():Number {
        return _zrot;
    }

    private var _velocity:Point3D = new Point3D();
    private var _dv:Point3D = new Point3D();
    private var _stretch:Point3D = new Point3D();
    private var _force:Point3D = new Point3D();
    private var _acceleration:Point3D = new Point3D();

    private var _desiredPosition:Point3D = new Point3D();
    private var _lookAtPosition:Point3D = new Point3D();
    private var _xPosition:Point3D = new Point3D();

    public function move():void {
        if(_camTarget != null) {

            _desiredPosition = _camTarget.coords.clone();
            _desiredPosition.add(positionOffset.clone())

            _stretch.x = (coords.x - _desiredPosition.x) * -stiffness;
            _stretch.y = (coords.y - _desiredPosition.y) * -stiffness;
            _stretch.z = (coords.z - _desiredPosition.z) * -stiffness;

            _dv.x = _velocity.x * damping;
            _dv.y = _velocity.y * damping;
            _dv.z = _velocity.z * damping;

            _force.x = _stretch.x - _dv.x;
            _force.y = _stretch.y - _dv.y;
            _force.z = _stretch.z - _dv.z;

            _acceleration.x = _force.x * (1 / mass);
            _acceleration.y = _force.y * (1 / mass);
            _acceleration.z = _force.z * (1 / mass);

            _velocity.add(_acceleration);

            _xPosition=coords.clone()
            _xPosition.add(_velocity)
            coords=_xPosition

            _lookAtPosition=_camTarget.coords.clone()
            _lookAtPosition.add(lookOffset.clone())
            lookAt(_lookAtPosition);
            if(Math.abs(_zrot) > 0) object.rotationY = _zrot;

        }
    }

}




/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{
    /**
     * シーンインスタンスです。
     */
    public var scene:Scene3D;
    /**
     * ビューインスタンスです。
     */
    public var view:View;
    /**
     * カメラインスタンスです。
     */
    public var camera:Camera3D;
    /**
     * カメラコントローラーです。
     */
    public var cameraController:CameraController;
    
    private var _viewWidth:int;
    private var _viewHeight:int;
    private var _scaleToStage:Boolean;

    /**
     * 新しい BasicTemplate インスタンスを作成します。
     * @param    viewWidth
     * @param    viewHeight
     * @param    scaleToStage
     */
    public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
        _viewWidth = viewWidth;
        _viewHeight = viewHeight;
        _scaleToStage = scaleToStage;
        
        // Creating scene
        scene = new Scene3D();
        scene.splitAnalysis = false; // not analysis for performance
        scene.root = new Object3D();
        
        // Adding camera
        camera = new Camera3D();
        camera.z = -1000;
        scene.root.addChild(camera);
        
        // camera contoller
        cameraController = new CameraController(this);
        cameraController.camera = camera;
        
        // set view
        view = new View();
        view.camera = camera;
        addChild(view);
        
        // stage
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理をオーバーライドして記述します。
     */
    protected function atInit():void {}
    
    /**
     * 初期化されたときに実行されるイベントです。
     * 初期化時に実行したい処理を記述します。
     */
    private var _onInit:Function = function():void { };
    public function get onInit():Function { return _onInit; }
    public function set onInit(value:Function):void {
        _onInit = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理をオーバーライドして記述します。
     */
    protected function atPreRender():void {}
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング前に実行したい処理を記述します。
     */
    private var _onPreRender:Function = function():void{};
    public function get onPreRender():Function { return _onPreRender; }
    public function set onPreRender(value:Function):void {
        _onPreRender = value;
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理をオーバーライドして記述します。
     */
    protected function atPostRender():void {
    }
    
    /**
     * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
     * レンダリング後に実行したい処理を記述します。
     */
    protected var _onPostRender:Function = function():void{};
    public function get onPostRender():Function { return _onPostRender; }
    public function set onPostRender(value:Function):void {
        _onPostRender = value;
    }
    
    /**
     * レンダリングを開始します。
     */
    public function startRendering():void {
        addEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    /**
     * レンダリングを停止します。
     */
    public function stopRendering():void {
        removeEventListener(Event.ENTER_FRAME, onRenderTick);
    }
    
    /**
     * シングルレンダリング(レンダリングを一回だけ)を実行します。
     */
    public function singleRender():void {
        onRenderTick();
    }
    
    /**
     * @private
     */
    private function init(e:Event = null):void {
        stage.scaleMode = StageScaleMode.NO_SCALE;
        stage.align = StageAlign.TOP_LEFT;
        stage.quality = StageQuality.HIGH;

        // resize
        stage.addEventListener(Event.RESIZE, onResize);
        onResize(null);
        
        // render
        startRendering();
        
        atInit();
        _onInit();
        
    }
    
    /**
     * @private
     */
    private function onRenderTick(e:Event = null):void {
        atPreRender();
        _onPreRender();
        scene.calculate();
        atPostRender();
        _onPostRender();
    }
    
    /**
     * @private
     */
    private function onResize(event:Event = null):void {
        if (_scaleToStage) {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
            view.graphics.clear()
            view.graphics.beginFill(0x000000)
            view.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)            
        }else {
            view.width = _viewWidth;
            view.height = _viewHeight;
            view.graphics.clear();
            view.graphics.beginFill(0x000000)
            view.graphics.drawRect(0,0,_viewWidth,_viewHeight)
        }
    }
}
