/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cB2l
 */

package 
{
	import flash.display.Sprite;
	import flash.media.Microphone;
	import flash.events.SampleDataEvent;
	import flash.media.Sound;
	import com.bit101.components.HUISlider;
	import flash.events.Event;
	
	public class MicDelay extends Sprite
	{
		private var _time:Number = 300;
		private var _bufSize:int = int(_time * .001 * 44100);
		private var _buf:Vector.<Number> = new Vector.<Number>(_bufSize);
		private var _dry:Number = .1;
		private var _wet:Number = .3;
		private var _fb:Number = .4; //feedback
		private var _position:Number = 0;
		
		private var _timeSlider:HUISlider;
		private var _drySlider:HUISlider;
		private var _wetSlider:HUISlider;
		private var _fbSlider:HUISlider;

		public function MicDelay() 
		{
			var mic:Microphone = Microphone.getMicrophone();
			mic.rate = 44;
			mic.addEventListener(SampleDataEvent.SAMPLE_DATA,process);
			
			var xp:Number = 100
			var yp:Number = 100
			
			_timeSlider = new  HUISlider(this, xp, yp,"time",setTime);
			_timeSlider.minimum = 30
			_timeSlider.maximum = 2000
			_timeSlider.value = _time;
			yp += 20
			_drySlider = new  HUISlider(this, xp, yp, "dry",setDry);
			_drySlider.minimum = .0
			_drySlider.maximum = 2.
			_drySlider.value = _dry;
			
			yp += 20
			_wetSlider = new  HUISlider(this, xp, yp, "wet",setWet);
			_wetSlider.minimum = .0
			_wetSlider.maximum = 2.0
			_wetSlider.value = _wet;
			
			yp += 20
			_fbSlider = new  HUISlider(this, xp, yp,"feedback",setFb);
			_fbSlider.minimum = .0
			_fbSlider.maximum = 2.0
			_fbSlider.value = _fb;
		}
		
		private function setTime(e:Event):void{
			_time = int(_timeSlider.value)
			_bufSize = int(_time * .001 * 44100);
			_buf = new Vector.<Number>(_bufSize);
		}
		
		
		private function setDry(e:Event):void{
			_dry = _drySlider.value
		}
		private function setWet(e:Event):void{
			_wet = _wetSlider.value
		}
		private function setFb(e:Event):void{
			_fb = _fbSlider.value;
		}
		private function process(e:SampleDataEvent):void{
			var s:Sound = new Sound();
			s.addEventListener(SampleDataEvent.SAMPLE_DATA,writeData);
			
			function writeData(se:SampleDataEvent):void{
				var len:int = e.data.length/4;
				for(var i:int = 0; i < len ; i++){		
					
					//1 delay
					var delay:Number = (_buf[_position])?_buf[_position]:0;
					var input:Number = e.data.readFloat();
					var wetSig:Number = input + delay * _fb;
					_buf[_position] = wetSig;
					_position++;
					_position %= _bufSize;
					var b:Number = input * _dry + wetSig * _wet;
		
					
					se.data.writeFloat(b);
					se.data.writeFloat(b);
				}
				s.removeEventListener(SampleDataEvent.SAMPLE_DATA,writeData);
			}		
			s.play();			
		}
	}
}
