/**
 * Copyright gameegg ( http://wonderfl.net/user/gameegg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cAvI
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class ParticleLine extends Sprite {
        
        private var space:Sprite;
        private var dotVector:Vector.<Dot> = new Vector.<Dot>();
        
        public function ParticleLine() {
            space = new Sprite();
            addChild(space);
            
            graphics.beginFill(0x0);
            graphics.drawRect(0,0,465,465);
            
            addEventListener("enterFrame",ef);
            
            
            for(var k:int=0; k< 10; ++k){
                var dot:Dot = new Dot(Math.random()*465,Math.random()*465,Math.random()*2-1,Math.random()*2-1);
                dotVector.push(dot);
            }
            
            stage.addEventListener(MouseEvent.CLICK,mc)

        }
        
        private function ef(e:Event):void {
            space.graphics.clear();
            
            for(var i:int = 1; i < dotVector.length; ++i) {
                var doti:Dot = dotVector[i];
                doti.update(); 
                
                for(var j:int = 0; j < i; ++j) {
                    var dotj:Dot = dotVector[j];
                    var r:Number = pit(doti.x,doti.y,dotj.x,dotj.y);
                    
                    space.graphics.lineStyle(100/r,0xffffff,70/r);
                    if(100/r > 3) space.graphics.lineStyle(3,0xffffff,70/r);
                    
                    space.graphics.moveTo(doti.x,doti.y);
                    space.graphics.lineTo(dotj.x,dotj.y);
                    
                    doti.sx -= (doti.sx-dotj.sy)/10;
                    doti.sy -= (doti.sx-dotj.sy)/10;
                    dotj.sx += (doti.sx-dotj.sy)/10;
                    dotj.sy += (doti.sx-dotj.sy)/10;
                }

            }

            
        }
        
        private function mc(e:MouseEvent):void {
            var mcDot:Dot = new Dot(mouseX,mouseY,0,0);
            dotVector.push(mcDot);
        }

        
        private function pit(a:Number,b:Number,c:Number,d:Number):Number {
            return Math.sqrt((a-c)*(a-c)+(b-d)*(b-d));
        }


    }
}

internal class Dot {
    public var x:Number;
    public var y:Number;
    
    public var sx:Number=0;
    public var sy:Number=0;
    
    public var ax:Number=0;
    public var ay:Number=0;
    
    public function Dot(ix:Number,iy:Number,isx:Number = 0,isy:Number = 0) {
        x = ix;
        y = iy;
        
        sx = isx;
        sy = isy;
        
        ax = Math.random()*2-1;
        ay = Math.random()*2-1;
        
    }
    
    public function update():void {
        sx += ax;
        sy += ay
        x += sx;
        y += sy;
        
        sx *= 0.5;
        sy *= 0.5;
        
        if(ax > 3) ax = 3;
        else if(ax < -3) ax = -3;
        if(ay > 3) ay = 3;
        else if(ay < -3) ay = -3;
        
        if(x < 0) ax +=0.1;
        else if(x > 465) ax -=0.1;
        
        if(y < 0) ay +=0.1;
        else if(y > 465) ay -=0.1;
    }


}
