/**
 * Copyright insocium ( http://wonderfl.net/user/insocium )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cAg4
 */

package

{

    import away3d.containers.View3D;

    import away3d.debug.AwayStats;

    import away3d.entities.Sprite3D;

    import away3d.materials.BitmapMaterial;

    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.StageAlign;

    import flash.display.StageScaleMode;

    import flash.events.Event;

    import flash.filters.BlurFilter;

    import flash.geom.Matrix;

    import flash.geom.Point;

    import flash.geom.Vector3D;

    import flash.utils.getTimer;

    

    /**

     * Depth of Field Demo

     * @author yasu

     */

    [SWF(frameRate=60,width=720,height=480)]

    

    public class Sprite3DVer extends View3D

    {

        

        private static const FOCUS_POSITION:int = 2000;

        private static const FOCUS_RANGE:int = 3000;

        private static const MAX_NUM:int = 800;

        private static const BLUR_DEPTH:int = 48;

        private static const CAMERA_RADIUS:Number = 2500;

        private static const RANDOM_LENGTH:Number = 4000;

        

        public function Sprite3DVer():void

        {

            // init

            stage.scaleMode = StageScaleMode.NO_SCALE;

            stage.align = StageAlign.TOP_LEFT;

            addChild(new AwayStats(this));

            camera.lens.far = 10000;

            camera.lens.near = 10;

            

            // bmp

            var orijinal:BitmapData = Bitmap(new ImageCls()).bitmapData;

            // create blur material

            var blurs:Vector.<BitmapData> = new Vector.<BitmapData>(BLUR_DEPTH, true);

            var mtx:Matrix = new Matrix(1, 0, 0, 1, (128 - orijinal.width) / 2, (128 - orijinal.height) / 2);

            for (var i:int = 0; i < BLUR_DEPTH; i++)

            {

                var blurFilter:BlurFilter = new BlurFilter(i, i, 4);

                // copy bitmapdata

                var bmd:BitmapData = new BitmapData(128, 128, true, 0x00000000);

                bmd.draw(orijinal, mtx);

                bmd.applyFilter(bmd, bmd.rect, new Point(), blurFilter);

                // save

                blurs[i] = bmd;

            }

            

            // init materials

            materials = new Vector.<BitmapMaterial>(BLUR_DEPTH, true);

            for (i = 0; i < BLUR_DEPTH; i++)

            {

                var mt:BitmapMaterial = new BitmapMaterial(blurs[i]);

                mt.alphaBlending = true;

                //mt.updateTexture();

                materials[i] = mt;

            }

            

            // init particle 

            particles = new Vector.<Sprite3D>(MAX_NUM, true);

            for (i = 0; i < MAX_NUM; i++)

            {

                var ball:Sprite3D = new Sprite3D(null, 500, 500);

                ball.x = RANDOM_LENGTH * (Math.random() - 0.5);

                ball.y = RANDOM_LENGTH * (Math.random() - 0.5);

                ball.z = RANDOM_LENGTH * (Math.random() - 0.5);

                scene.addChild(ball);

                particles[i] = ball;

            }

            

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);

        }

        

        [Embed(source="assets/image.png")]

        private var ImageCls:Class;

        private var materials:Vector.<BitmapMaterial>;

        private var particles:Vector.<Sprite3D>;

        

        private function enterFrameHandler(e:Event):void

        {

            // camera motion

            camera.x = Math.sin(getTimer() / 2000) * CAMERA_RADIUS;

            camera.z = Math.cos(getTimer() / 2000) * CAMERA_RADIUS;

            camera.y = CAMERA_RADIUS * Math.cos(getTimer() / 2000);

            camera.lookAt(new Vector3D());

            

            // update particle

            for (var i:int = 0; i < MAX_NUM; i++)

            {

                var p:Sprite3D = particles[i];

                

                // calc distance

                var distance:Number = Math.abs(Vector3D.distance(camera.position, p.position) - FOCUS_POSITION);

                var blurVal:int = Math.floor((distance / FOCUS_RANGE) * BLUR_DEPTH);

                blurVal = Math.max(0, Math.min(BLUR_DEPTH - 1, blurVal));

                

                // update material

                p.material = materials[blurVal];

            }

            

            render();

        }

    }

}