/**
 * Copyright rickyhk ( http://wonderfl.net/user/rickyhk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cAMp
 */

// forked from rickyhk's code test template
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{


    private function _init():void
    {
        _debug(
            "Start \n"
        );
        
        var points:Vector.<Point> = new Vector.<Point>();
        
        for (var i:uint = 0; i<10; i++){
            points.push(new Point(Math.round(Math.random() * 10000)),new Point(Math.round(Math.random() * 1000)));
        }
        // This way is fast
        var ret:Number = getGreatestX(points);
        var greatestX1:Number = !isNaN(ret) ? ret : 0;
         
        // This way gets it all on one line at the cost and without a
        // temporary variable, but it's painfully slow!
        var greatestX2:Number = getGreatestX(points) ? getGreatestX(points) : 0;
         
        // This way is elegant, fast, and the point of this article
        var greatestX3:Number = getGreatestX(points) || 0;
        
        var x:String;
        _debug("" + x);
        _debug(x || "x is false");
        
        var x2:*;
        _debug("" + x2);
        _debug(x2 || "x2 is false");
        
        _debug(greatestX1 + " " + greatestX2 + " " + greatestX3);
        
        //var b:Object = {x:0,y:0};
        //foo(b);        
        
        _measure("initialize", function ():void
        {
            var a:Array = new Array();
            for (var i:uint = 0; i<100000; i++){
                a[i] = new Point(i ,i + Math.round(Math.random()*10));
            }

        });
        
        _measure("initialize", function ():void
        {
            var a:Array = new Array();
            for (var i:uint = 0; i<100000; i++){
                a[i] = new Point(i ,i + Math.round(Math.random()*10));
                var b:String = foo(a[i]);
            }

        });
        
        _measure("initialize", function ():void
        {
            var a:Array = new Array();
            for (var i:uint = 0; i<100000; i++){
                a[i] = new Point(i ,i + Math.round(Math.random()*10));
                var b:String = foo2(a[i]);
            }

        });
        
        _measure("concat", function ():void
        {
            var evens:Array = [2,4,6,8];
            var odds:Array = [1,3,5,7];
            for (var i:uint = 0; i<100000; i++){
                evens = [2,4,6,8];
                odds = [1,3,5,7];
            
            // you can pass null instead of odds but you can't pass nothing (no crash though!)
            //odds.push(9);
            //odds = odds.concat(evens);
            var temp:Array = odds.concat(evens);
            odds = temp;
            }
            _debug(""+odds);
            _debug(""+evens);
        });
        
        
        
        _measure("push", function ():void
        {
            
            var evens:Array = [2,4,6,8];
            var odds:Array = [1,3,5,7];
            for (var i:uint = 0; i<100000; i++){
                evens = [2,4,6,8];
                odds = [1,3,5,7];
            
            // you can pass null instead of odds but you can't pass nothing (no crash though!)
            //odds.push(9);
            odds.push.apply(null, evens);
            }
            _debug(""+odds);
            _debug(""+evens);
        });
        
        
        
        _debug("\nEnd");
    }
    
    private function foo(o:Object): String
    {
        return "" + Point(o).x + Point(o).y;
    }
    
    private function foo2(o:Object): String
{
    return "" + (o as Point).x + (o as Point).y;
}
    
     // This function is non-trivial and will take a while to run if you have a large array
    private function getGreatestX(points:Vector.<Point>): Number
    {
        if (points == null || points.length == 0)
        {
            return NaN;
        }
        var greatestIndex:int = 0;
        var greatestX:Number = points[0].x;
        var len:uint = points.length;
        for (var i:int = 1; i < len; ++i)
        {
            var x:Number = points[i].x;
            if (x > greatestX)
            {
                greatestIndex = i;
                greatestX = x;
            }
        }
        return greatestX;
    }    
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;

        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
