/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/c9Qu
 */



package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
  
     
    public class Main extends Sprite
    {
        private const FRAMERATE:int = 0;        

        
        public function Main():void
        {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // config stage
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.BEST;
            stage.stageFocusRect = false;
            stage.tabChildren    = false;
            
            stage.frameRate = FRAMERATE;
            
            this.graphics.beginFill(0x333333);
            this.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            this.graphics.endFill();            
            
            // add custom menu
            new CustomMenu(this);
            
            // run the swf            
            run();
            
        }
        
        // == APP ==
        private function run():void 
        {            
            // define 2 Points !
            var A:Point = new Point(80, 80);
            var B:Point = new Point(280, 280);
            
            // display the result using Point.distance(p1,p2); static method
            buildTextField(this, 'Calculate the distance between 2 Vector3D points in a 3D environment:' );
            buildTextField(this, 'Point.distance(p1:Point, p2:Point), Static method of the Point class.',0 ,20 );
            buildTextField(this, 'Distance Between A' + A.toString() + ' and B' + B.toString() + ' is : ' + Point.distance(A, B).toFixed(2), 0, 36);
            
            // drawing the result for fun
            this.graphics.beginFill(0xCC0000);
            this.graphics.drawCircle(A.x, A.y, 3.5); // thx to stage quality low ^^
            this.graphics.drawCircle(B.x, B.y, 3.5);
            this.graphics.endFill();
            
            this.graphics.lineStyle(2, 0xFFFF00, 1, true, LineScaleMode.NONE);
            this.graphics.moveTo(A.x, A.y);
            this.graphics.lineTo(B.x, B.y);
            
            buildTextField(this, 'A' + A.toString(), A.x + 12, A.y - 9);
            buildTextField(this, 'B' + B.toString(), B.x + 12, B.y - 9);
        }
        
        private function buildTextField(doc:DisplayObjectContainer, txt:String, x:int = 0, y:int = 0):TextField
        {
            var fmt:TextFormat = new TextFormat;
            fmt.color = 0xFFFFFF;
            fmt.font = 'Arial';
            fmt.size = 11;
            
            var tf:TextField = new TextField;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.opaqueBackground = 0x333333; // opaque background allow a perfect font rendering even in StageQuality.LOW mode
            tf.selectable = false;
            tf.defaultTextFormat = fmt;
            tf.text = txt;
            tf.x = x;
            tf.y = y;
            
            doc.addChild(tf);
            
            return tf;
        }
    
    }

}

import flash.display.Sprite;
import flash.events.ContextMenuEvent;
import flash.net.navigateToURL;
import flash.net.URLRequest;
import flash.ui.ContextMenu;
import flash.ui.ContextMenuItem;

internal class CustomMenu
{
    
    private const NAME:String = "Flash Tips Collection : Calculate distance between 2 points";
    
    public function CustomMenu(ref:Sprite):void
    {
        var appContextMenu:ContextMenu = new ContextMenu;
        appContextMenu.hideBuiltInItems();
        
        var cmi:ContextMenuItem = new ContextMenuItem(NAME);
        var credits:ContextMenuItem = new ContextMenuItem("by YopSolo");
        appContextMenu.customItems.push(cmi);
        appContextMenu.customItems.push(credits);
        
        cmi.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCollection);
        credits.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, _onClickCredits);
        
        ref.contextMenu = appContextMenu;
    }
    
    private function _onClickCollection(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr/wp/2012/01/14/flash-tips-collection/'), '_blank');
    }
    
    private function _onClickCredits(e:ContextMenuEvent):void
    {
        navigateToURL(new URLRequest('http://www.yopsolo.fr'), '_blank');
    }
}





/*
     * @author YopSolo
     * Cool to know that there is a built-in method to do the job :)
     * ** ** ** ** ** ** ** ** **
     * Note : if you need good performance (in a loop for example ) avoid Math.pow, Math.sqrt and Point.distance
     * use  
     * if(dx<0) dx *=-1;
     * if(dy<0) dy *=-1;
     * distance = dx+dy;
     *
     * This way to compute distance is faster than the static build-in method
     * 
*/ 