/**
 * Copyright nulldesign ( http://wonderfl.net/user/nulldesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c9E0
 */

/*
	円にしたけど緩やかなカーブだけいくつも重ねてもきれいそう。
	1/BitmapDataの背景遊び
	@nulldesign
*/

package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import caurina.transitions.*;
    import caurina.transitions.properties.*;
    
    public class DotsLine extends Sprite {
    	
    	private var _bmpDat:BitmapData;
    	private var _map:Sprite;
    	private var _line:Sprite;
    	private var _pointList:Array;
    	private var _f:BlurFilter;
    	private var _fValue:Number = 48;
    	private var _lineWaight:Number = 48;
    	private var _nums:uint = 5;
    	private var _R:Number = 120;
    	
    	private var _timer:Timer;
    private var _colorTimer:Timer;
    	
        public function DotsLine() {
            // write as3 code here..
            addEventListener(Event.ADDED_TO_STAGE, initialize );
        }
        
        private function initialize(e:Event):void
        {
        	
        		this.graphics.beginFill( 0x000000 );
        		this.graphics.drawRect( 0, 0, 465, 465 );
        		this.graphics.endFill();
        	
        		var _sp:Sprite = new Sprite();
        		var _g:Graphics = _sp.graphics;
        		_g.beginFill( 0x000000 );
        		_g.drawRect( 0, 0, 1, 1 );
        		_g.drawRect( 1, 1, 1, 1 );
        		_g.drawRect( 2, 2, 1, 1 );
        		
        		_bmpDat = new BitmapData( 3, 3, true, 0x00000000 );
        		_bmpDat.draw(_sp );
        		
        		_map = new Sprite();
        		_map.graphics.beginBitmapFill(_bmpDat);
        		_map.graphics.drawRect( 0, 0, 465, 465 );
        		_map.cacheAsBitmap = true;
        		
        		addChild( _map );
        		
        		_pointList = [];
        		
        		_line = new Sprite();
        		_line.cacheAsBitmap = true;
        		
        		_f = new BlurFilter( _fValue, _fValue, 1 );
        		_line.filters = [ _f ];
        		
        		addChild( _line );
        		
        		_map.mask = _line;
        		
        		for( var i:uint = 0; i<_nums; i++ )
        		{
        			var _p:CurvePoint = new CurvePoint();
        			_pointList.push(_p );
        			_p.x = Math.cos( ( i * ( 360 / _nums ) ) * Math.PI / 180 ) * _R + ( 465 >> 1 );
        			_p.y = Math.sin( ( i * ( 360 / _nums ) ) * Math.PI / 180 ) * _R + ( 465 >> 1 );
        			_p.bx = _p.tx = _p.x
        			_p.by = _p.ty = _p.y;
        			_p.x = 465 >> 1;
        			_p.y = 465 >> 1;
        		}
        		
        		ColorShortcuts.init();
        		
        		_timer = new Timer( 1000 );
        		_timer.addEventListener(TimerEvent.TIMER, _onTimerHandler );
        		_timer.start();
        		
        		_colorTimer = new Timer( 3000 );
        		_colorTimer.addEventListener( TimerEvent.TIMER, _onColorTimerHandler );
        		_colorTimer.start();
        		addEventListener(Event.ENTER_FRAME, _render );
        }
        
        private function _onTimerHandler( e:TimerEvent ):void
        {
        		var len:uint = _pointList.length;
        		for(var i:uint = 0; i<len; i++ )
        		{
        			var _p:CurvePoint = _pointList[i] as CurvePoint;
        			_p.tx = _p.bx + Math.random()*36 - 18;
        			_p.ty = _p.by + Math.random()*36 - 18;
        		}
        		
        }
        
        private function _onColorTimerHandler( e:TimerEvent ):void
        {
	        	Tweener.addTween( _map, { _color: Math.random() * 0xFFFFFF, time:3, transition: 'linear' });
	        	
	        var 	_targetLineWaight:Number = Math.floor( Math.random() * 24 ) + 12;
	        	Tweener.addTween( this, { _lineWaight: _targetLineWaight, time: 3} );
        }
        
        private function _render( e:Event ):void
        {
        		loop();
        }
        public function loop():void
        {
        		var len:uint = _pointList.length;
        		for(var i:uint = 0; i < len; i++ )
        		{
        			var _p:CurvePoint = _pointList[i] as CurvePoint;
        			_p.vx = (_p.vx + ( _p.tx - _p.x ) / 10 ) / 1.105000;
        			_p.vy = (_p.vy + ( _p.ty - _p.y ) / 10 ) / 1.105000;
        			_p.x += _p.vx;
        			_p.y += _p.vy;
        		}
        	
        	
        		_line.graphics.clear();
        		_line.graphics.lineStyle( _lineWaight, 0x000000 );
        		
			var _averageX:Number = ( _pointList[0].x + _pointList[len-1].x ) * .5;
			var _averageY:Number = ( _pointList[0].y + _pointList[len-1].y ) * .5;
			_line.graphics.moveTo( _averageX, _averageY);
        		for( i = 0; i < len-1; i++)
        		{
				_p = _pointList[i] as CurvePoint;
				_averageX = ( _p.x + _pointList[i+1].x ) * .5;
				_averageY = ( _p.y + _pointList[i+1].y ) * .5;
				_line.graphics..curveTo( _p.x, _p.y,  _averageX, _averageY );
        		}
        		
			_p = _pointList[len-1] as CurvePoint;
			_averageX = ( _pointList[len-1].x + _pointList[0].x ) * .5;
			_averageY = ( _pointList[len-1].y + _pointList[0].y ) * .5;
			_line.graphics..curveTo( _p.x, _p.y,  _averageX, _averageY );
        }
    }
}

class CurvePoint
{
	public var x:Number;
	public var y:Number;
	public var tx:Number = 0;
	public var ty:Number = 0;
	public var bx:Number = 0;
	public var by:Number = 0;
	public var vx:Number = 0;
	public var vy:Number = 0;
}