/**
 * Copyright rlldi ( http://wonderfl.net/user/rlldi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c8d4
 */

// forked from awef's ライフゲーム
package
{
    import flash.display.AVM1Movie;
    import flash.display.Sprite
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    
    public class Main extends Sprite
    {
        //セルのサイズ
        private const cellSize :int = 2;
        //セルを横に並べる数
        private const gameWidth :int = 100;
        //セルを縦に並べる数
        private const gameHeight :int = 100;
        //何ミリ秒おきに世代を進める処理を行うか
        private var interval :int = 50;
        //マッピングデータ
        //getMappingData_diehard, getMappingData_acorn, getMappingData_bleeder1, getMappingData_bleeder2, getMappingData_max が用意されている
        private var src :Array = getMappingData_max();
        //フレームを進めるかどうか
        private var toCalc:Boolean = true;

        private var game :Sprite; //セルが描写されるエリア
        private var dat :Array; //セルのデータを格納する配列
        private var timer :Timer;

        public function Main()
        {
            //セルのデータを格納する配列の生成
            var i :int;
            var ii :int;
            dat = new Array();
            
            var mx:int = (gameWidth - src[0].length)/2;
            var my:int = (gameHeight - src.length)/2;

            for (i = 0; i < gameWidth; i++)
            {
                dat.push(new Array());
                for (ii = 0; ii < gameHeight; ii++) {
                    dat[i].push(
                        src[ii-my] && 
                        i >= mx &&
                        i < mx + src[ii-my].length &&
                        src[ii-my].substr(i-mx,1)=="1"
                    );
                }
            }
            
            //画面のセットアップ
            graphics.beginFill(0xEEEEEC);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            game = new Sprite();
            clear();
            game.x = Math.floor((stage.width - game.width) / 2);
            game.y = Math.floor((stage.height - game.height) / 2);
            stage.addChild(game);
            
            //タイマーのスタート
            timer = new Timer(interval, 0);
            timer.addEventListener("timer", change);
            timer.start();
        }
        
        //タイマーを一時停止させ、世代を一つ進めて再描写
        private function change(e :TimerEvent) :void
        {
            timer.stop();
            if (toCalc) calc();
            clear();
            draw();
            timer.start();
        }
        
        //セルを描写
        private function draw() :void
        {
            var i :int;
            var ii :int;
            
            for (i = 0; i < gameWidth; i++)
            {
                for (ii = 0; ii < gameHeight; ii++)
                {
                    if (dat[i][ii])
                    {
                        game.graphics.beginFill(0);
                        game.graphics.drawRect(i * cellSize, ii * cellSize, cellSize, cellSize);
                        game.graphics.endFill();
                    }
                }
            }
        }
        
        //セルの描写のクリア
        private function clear() :void
        {
            game.graphics.clear();
            game.graphics.beginFill(0xFFFFFF);
            game.graphics.drawRect(0, 0, cellSize * gameWidth, cellSize * gameHeight);
            game.graphics.endFill();
        }
        
        //世代を一つ進める
        private function calc() :void
        {
            //次世代で死亡するセルのリスト
            var dlist :Array = new Array();
            //次世代で誕生するセルのリスト
            var blist :Array = new Array();
            
            var count :int;
            
            var i :int;
            var ii :int;
            
            for (i = 0; i < gameWidth; i++)
            {
                for (ii = 0; ii < gameHeight; ii++)
                {
                    //セルの周囲の生存セルをカウント
                    count = 0;
                    //左のセル
                    if (i - 1 >= 0 && dat[i - 1][ii])
                        count++;
                    //右のセル
                    if (i + 1 < gameWidth && dat[i + 1][ii])
                        count++;
                    //上のセル
                    if (ii - 1 >= 0 && dat[i][ii - 1])
                        count++;
                    //下のセル
                    if (ii + 1 < gameHeight && dat[i][ii + 1])
                        count++;
                    //左上のセル
                    if (i - 1 >= 0 && ii - 1 >= 0 && dat[i - 1][ii - 1])
                        count++;
                    //左下のセル
                    if (i - 1 >= 0 && ii + 1 < gameHeight && dat[i - 1][ii + 1])
                        count++;
                    //右上のセル
                    if (i + 1 < gameWidth && ii - 1 >= 0 && dat[i + 1][ii - 1])
                        count++;
                    //右下のセル
                    if (i + 1 < gameWidth && ii + 1 < gameHeight && dat[i + 1][ii + 1])
                        count++;
                    
                    //死亡、かつ周囲に3つ生きているセルが有れば次世代で誕生させるリストに追加
                    if (!dat[i][ii] && count == 3)
                        blist.push([i, ii]);
                    //生存、かつ周囲の生存セル数が2か3で無い場合に次世代で死亡させるリストに追加
                    if (dat[i][ii] && count != 2 && count != 3)
                        dlist.push([i, ii]);
                }
            }
            
            //誕生リスト及び死亡リストにあるセルを処理
            var s :String;
            for (s in blist)
                dat[blist[s][0]][blist[s][1]] = true;
            for (s in dlist)
                dat[dlist[s][0]][dlist[s][1]] = false;
        }
        private function getMappingData_diehard() : Array {
            return new Array(
                "00000010",
                "11000000",
                "01000111"
            );
        }
        private function getMappingData_acorn() : Array {
            return new Array(
                "0100000",
                "0001000",
                "1100111"
            );
        }
        private function getMappingData_bleeder1() : Array {
            return new Array(
                "00000010",
                "00001011",
                "00001010",
                "00001000",
                "00100000",
                "10100000"
            );
        }
        private function getMappingData_bleeder2() : Array {
            return new Array(
                "11101",
                "10000",
                "00011",
                "01101",
                "10101"
            );
        }
        private function getMappingData_max() : Array {
            return new Array(
                "00000101000000000000000000000",
                "00001001000000000000000000000",
                "00011000000000000000000000000",
                "00100000000000000000000000000",
                "01111000000000000000000000000",
                "10000100000000000000000000000",
                "10010000000000000000000000000",
                "10010000000000000000000000000",
                "01000000000111000111000000000",
                "00111101001001000100100000000",
                "00010001000001000100000000000",
                "00001000000001000100000000000",
                "00001010000001000100000000000",
                "00000000000000000000000000000",
                "00011100000111000111000000000",
                "00011000000010000010000000000",
                "00011100000011111110000000000",
                "00000000000100000001000000000",
                "00001010001111111111100000000",
                "00010010010000000000001100000",
                "00010000011111111111100010000",
                "00010001000000000000010001000",
                "00001000111111111111000001000",
                "00000110000000000001001001000",
                "00000000111111111110001010000",
                "00000000010000000100000000000",
                "00000000001111111000000111000",
                "00000000001000001000000011000",
                "00000000011100011100000111000",
                "00000000000000000000000000000",
                "00000000000100010000001010000",
                "00000000000100010000000010000",
                "00000000000100010000010001000",
                "00000000100100010010010111100",
                "00000000011100011100000000010",
                "00000000000000000000000001001",
                "00000000000000000000000001001",
                "00000000000000000000000100001",
                "00000000000000000000000011110",
                "00000000000000000000000000100",
                "00000000000000000000000011000",
                "00000000000000000000010010000",
                "00000000000000000000010100000"
            );
        }
    }
}
