/**
 * Copyright Horiuchi_H ( http://wonderfl.net/user/Horiuchi_H )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c7oK
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	
	[SWF(width=465, height=465, frameRate=30, backgroundColor="#ffffff")]
	
	/**
	 * via http://ja.doukaku.org/12/
	 */
	public class ExistsWeek extends Sprite 
	{
		private static const DISPLAY_DAY:Array = ["", "月", "火", "水", "木", "金", ""];
		
		private var inputFields:Vector.<TextField> = new Vector.<TextField>();
		private var outputField:TextField = new TextField();
		
		public function ExistsWeek() {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			drawInputArea();
			drawOutputArea();
		}
		
		public function calcSameWeek():void {
			var year:int = int(inputFields[0].text);
			var month:int = int(inputFields[1].text);
			var date:int = int(inputFields[2].text);
			if (year * month * date == 0) return;
			
			var base:Date = new Date(year, month - 1, date);
			base.date -= base.day;
			outputField.text = "";
			for (var index:int = 1; index <= 5; index++) {
				base.date += 1;
				outputField.appendText(convertString(base));
			}
		}
		private function convertString(d:Date):String {
			return DISPLAY_DAY[d.day] + " " + d.fullYear + "/" + convertDigits(d.month + 1, 2) + "/" + convertDigits(d.date, 2) + "\n";
		}
		private function convertDigits(i:int, count:int):String {
			var res:String = String(i);
			var len:int = count - res.length;
			for (var index:int = 0; index < len; index++) {
				res = "0" + res;
			}
			return res;
		}
		
		private function drawInputArea():void {
			var xOffset:int = 10;
			var yOffset:int = 10;
			
			var label:TextField = new TextField();
			label.text = "input date:";
			label.autoSize = TextFieldAutoSize.LEFT;
			label.x = xOffset;
			label.y = yOffset;
			addChild(label);
			xOffset += label.width;
			
			var yearField:TextField = createInputField(4);
			yearField.x = xOffset;
			yearField.y = yOffset;
			inputFields.push(yearField);
			addChild(yearField);
			xOffset += yearField.width;
			
			var sep1:TextField = new TextField();
			sep1.text = "/";
			sep1.autoSize = TextFieldAutoSize.LEFT;
			sep1.x = xOffset;
			sep1.y = yOffset;
			addChild(sep1);
			xOffset += sep1.width;
			
			var monthField:TextField = createInputField(2);
			monthField.x = xOffset;
			monthField.y = yOffset;
			inputFields.push(monthField);
			addChild(monthField);
			xOffset += monthField.width;
			
			var sep2:TextField = new TextField();
			sep2.text = "/";
			sep2.autoSize = TextFieldAutoSize.LEFT;
			sep2.x = xOffset;
			sep2.y = yOffset;
			addChild(sep2);
			xOffset += sep2.width;
			
			var dateField:TextField = createInputField(2);
			dateField.x = xOffset;
			dateField.y = yOffset;
			inputFields.push(dateField);
			addChild(dateField);
			xOffset += dateField.width;
			
		}
		private function createInputField(digits:int):TextField {
			var field:TextField = new TextField();
			field.type = TextFieldType.INPUT;
			field.multiline = false;
			field.wordWrap = false;
			field.border = true;
			field.width = digits * 10;
			field.height = 20;
			
			field.addEventListener(Event.CHANGE, function(event:Event):void {
				calcSameWeek();
			});
			return field;
		}
		
		private function drawOutputArea():void {
			outputField.autoSize = TextFieldAutoSize.LEFT
			outputField.multiline = true;
			outputField.wordWrap = false;
			
			outputField.x = 10;
			outputField.y = 40;
			addChild(outputField);
		}
	}
}
