/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c7oC
 */

package 
{
	import flash.display.Sprite;
	
	/**
	 * ...
	 * @author 9re
	 */
	public class SteinerChain extends Sprite
	{
		private var _scale:Number = 60;
		private var _cx:Number;
		private var _cy:Number;
		
		public function SteinerChain() 
		{
			var n:int = 7;
			var r:Number = 0.7;
			var X:Number = 0.4;
			var Y:Number = 0.1;
			var t:Number = Math.PI / n;
			var rho:Number = r * Math.sin(t) / (1 - Math.sin(t));
			t = 2 * t;
			var s:Number;
			
			_cx = stage.stageWidth / 2;
			_cy = stage.stageHeight / 2;
			
			
			
			graphics.beginFill(0xff6666);
			draw(X, Y, r + rho * 2);
			graphics.endFill();
			
			graphics.beginFill(0x666666);
			draw(X, Y, r);
			graphics.endFill();
			
			
			for (var i:int = 0; i < n; ++i) 
			{
				s = i * t + Math.PI / 2;
				graphics.beginFill(0x999999);
				draw(X + (r + rho) * Math.cos(s), Y + (r + rho) * Math.sin(s), rho);
				graphics.endFill();
			}

                        graphics.lineStyle(1, 0x333333);
                        graphics.moveTo(0, _cy);
                        graphics.lineTo(_cx * 2, _cy);
                        graphics.moveTo(_cx, 0);
                        graphics.lineTo(_cx, 2 * _cy);
		}
		
		public function draw(cx:Number, cy:Number, cr:Number):void {
			var c:Number = cx * cx + cy * cy - cr * cr;
			var rx:Number, ry:Number, rr:Number;
			rx = cx / c * _scale + _cx;
			ry = -cy / c * _scale + _cy;
			rr = cr / c * _scale;
			var i:int = 20 * Math.random();

			graphics.drawCircle(cx * _scale + _cx, -cy * _scale + _cy, cr * _scale);
		}
		
	}
	
}

