/**
 * Copyright MisterKK ( http://wonderfl.net/user/MisterKK )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c6Ug
 */

package 
{
	import flash.events.*;
	import flash.media.*;
	import flash.text.*;
	import flash.ui.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.typography.*;
	import org.papervision3d.typography.fonts.*;
	import org.papervision3d.view.*;

	/**
	 * ...
	 * @author MisterKK
	 */

	[SWF(width="640", height="480",　backgroundColor="0x333333", frameRate="30")]

	public class Main extends BasicView {
		// 効果音埋め込み
		//[Embed(source='se/sen_ge_byun02.mp3')]
		//private var jumpSE:Class;
		//[Embed(source='se/sen_ge_gusya01.mp3')]
		//private var damageSE:Class;
		//[Embed(source='se/sen_ge_bom04.mp3')]
		//private var gameoverSE:Class;
		//[Embed(source='se/se02-10.mp3')]
		//private var clearSE:Class;
		//[Embed(source='se/ta_ta_kira02.mp3')]
		//private var gemSE:Class;
		
		// BGM埋め込み
		//[Embed(source='se/n13.mp3')]
		//private var mainBGM:Class;
		//[Embed(source='se/se02-r04.mp3')]
		//private var titleBGM:Class;
		//[Embed(source='se/se02-r08.mp3')]
		//private var endBGM:Class;
		
		private var max_walls:int = 50; // 障害物の最大数
		private var walls:Array = new Array(max_walls); //障害物用の配列
		private var gems:Array; //お宝用の配列

		private var bg:Cube;  // 背景
		private var damage_fl:Plane; // ぶつかったときのフィルター(赤)
		private var coneMan:ConeMan; // コーンマン(主役)
		private var gem:ConeGem; // お宝
		private var coneMan2:ConeMan;// 以下タイトル用
		private var coneLog1:ConeLog;
		private var coneLog2:ConeLog;		
		
		private var debug_mes:Text3D;//デバッグ用
		private var damage:Text3D;//ダメージ
		private var lefttime:Text3D;//残り時間
		private var stage_text:Text3D;//ステージ
		private var gems_text:Text3D;//お宝数

		private var stageclear:Text3D;//ステージクリア
		private var gameover:Text3D;//ゲームオーバー
		private var title_mes1:Text3D;//以下タイトル用
		private var title_mes2:Text3D;
		private var title_mes3:Text3D;
		private var end_mes:Text3D; // エンディング用
		
		//private var jump_sound:Sound = new jumpSE();// ジャンプ音
		//private var damage_sound:Sound = new damageSE();   // ダメージ音
		//private var clear_sound:Sound  = new clearSE();   // クリア音
		//private var gameover_sound:Sound  = new gameoverSE();   // ゲームオーバー音
		//private var gem_sound:Sound  = new gemSE();   // お宝ゲット音

		//private var bgm:Sound  = new mainBGM();   // BGM
		//private var titlebgm:Sound  = new titleBGM();   // タイトルBGM
		//private var endbgm:Sound  = new endBGM();   // エンドBGM
		//private var channel:SoundChannel; // BGM用のチャンネル

		private var move_r:int;// キー操作用
		private var move_l:int;
		private var move_u:int;
		private var move_d:int;
		
		private var is_jump:Boolean;//ジャンプアクション用
		private var jump_y:int;

		private var wall_count:int; // 障害物用
		private var next_count:int;

		private var damage_count:int; //ダメージカウンタ
		private var clear_count:int;
		private var over_count:int;
		private var stage_count:int = 1;//ステージカウンタ		
		private var gems_count:int = 0;//お宝カウンタ		

		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}

		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			ConeManAdv();
		}

		public function initGame():void {  // 各種変数を初期化
			move_r =0;
			move_l =0;

			move_u = 0;
			move_d = 0;
		
			is_jump = false;
			jump_y = 0;
			wall_count = 0;
			next_count = 0;
		
			damage_count = 0;
			clear_count = 0;
			over_count = 0;
			
			bg.z = 5000;
//			bg.z = -400;
			coneMan.Init();

			stageclear.scale = 0.01;
			stageclear.visible = false;
			
			gameover.scale = 0.01;
			gameover.visible = false;
			
			bg.visible = true;
			damage_fl.visible = false;
			
			for (var i:int = 0;i < max_walls; i++) {  // 障害物を初期化
				var r:Number;
				r = Math.random();
				if ( r < 0.25) {
					walls[i] = new ConeNeedle();
				} else if ( r < 0.5) {
					walls[i] = new ConeArrow();
				} else if ( r < 0.75) {
					walls[i] = new ConeLog();
				}  else {
					walls[i] = new ConeWall();
				}
				walls[i].z = 10000;
				walls[i].visible = false;
				scene.addChild(walls[i])
			}

			walls[0].visible = true;

			gem.Init(bg.z);
			gem.visible = true;
						
			damage.text = "Damage : " + damage_count.toString() + "/10";
			gems_text.text = "Gems : " + gems_count.toString();
			//channel = bgm.play();
		}
		public function removeWalls():void  { // 障害物をクリア
			for (var i:int = 0;i < max_walls; i++) {
				walls[i].visible = false;
				scene.removeChild(walls[i]);
			}
			gem.visible = false;
		}

		public function ConeManAdv():void  { //ゲーム開始
			// entry point
			//super( 0, 0, true, true, CameraType.TARGET );

			var light:PointLight3D = new PointLight3D();		   
			var mats:MaterialsList = new MaterialsList();
			mats.addMaterial(new ColorMaterial(0x4444FF, 0), "top");
			mats.addMaterial(new ColorMaterial(0xFF4444, 0), "bottom");
			mats.addMaterial(new WireframeMaterial(0xFFFFFF), "left");
			mats.addMaterial(new WireframeMaterial(0xFFFFFF), "right");
			mats.addMaterial(new ColorMaterial(0x000000), "front");
			mats.addMaterial(new ColorMaterial(0x000000, 0), "back");
			bg = new Cube(mats, 2000, 10000, 1200, 1, 1, 10, Cube.FRONT + Cube.LEFT + Cube.RIGHT);
			bg.visible = false;

			coneMan = new ConeMan();
			coneMan2 = new ConeMan();
			coneLog1 = new ConeLog();
			coneLog2 = new ConeLog();
			
			gem = new ConeGem();
				
			damage_fl = new Plane(new ColorMaterial(0xFF0000, 0.3), 640, 480);
			damage_fl.z = -800;
			damage_fl.visible = false;
			
			var font:HelveticaMedium = new HelveticaMedium();
			var l_mat:Letter3DMaterial = new Letter3DMaterial(0xFFFFFF);
			l_mat.oneSide = false;
			debug_mes = new Text3D("", font, l_mat);
   			debug_mes.moveDown(600);
			
			damage = new Text3D("", font, l_mat);
			damage.align = "left";
   			damage.moveUp(640);
   			damage.moveLeft(900);

			gems_text = new Text3D("", font, l_mat);
			gems_text.align = "left";
   			gems_text.moveDown(640);
   			gems_text.moveLeft(900);

			stage_text = new Text3D("", font, l_mat);
			stage_text.align = "left";
   			stage_text.moveUp(640);
   			stage_text.moveLeft(125);

			lefttime = new Text3D("", font, l_mat);
			lefttime.align = "left";
   			lefttime.moveUp(640);
   			lefttime.moveRight(360);

			stageclear = new Text3D("STAGE CLEAR", font, new Letter3DMaterial(0xFF0000) );
			stageclear.z = -500;
			
			gameover = new Text3D("GAME OVER", font, new Letter3DMaterial(0xFF0000) );
			gameover.z = -500;

			title_mes1 = new Text3D("ConeMan", font, new Letter3DMaterial(0x0000FF));
			title_mes1.scale = 2;
			title_mes1.y = 250;
			title_mes1.z= -300;
			title_mes2 = new Text3D("Adventure", font, new Letter3DMaterial(0x0000FF));
			title_mes2.scale = 2;
			title_mes2.y = 150;
			title_mes3 = new Text3D("PUSH ANY KEY", font, l_mat);
			title_mes3.y = -150;

			end_mes = new Text3D("ConeMan", font, new Letter3DMaterial(0xFF0000));
			end_mes.scale = 1;
			end_mes.y = 250;
			end_mes.z= -300;
			end_mes.visible = false;
			
			scene.addChild(coneMan);
			scene.addChild(coneMan2);
			scene.addChild(title_mes1);
			scene.addChild(title_mes2);
			scene.addChild(title_mes3);
			scene.addChild(coneLog1);
			scene.addChild(coneLog2);
			scene.addChild(gem);
			startRendering();

			gameTitle();
		}

		private function gameTitle():void {	//タイトル表示
			coneMan.x = -600;
			coneMan.y = 0;
			coneMan.rotationY = 90;
			coneLog1.x = -700;
			coneLog1.rotationY = 90;
			coneMan2.x = 600;
			coneMan2.y = 0;
			coneMan2.rotationY = -90;
			coneLog2.x = 700;
			coneLog2.rotationY = -90;
			//channel = titlebgm.play();
			//channel.addEventListener(Event.SOUND_COMPLETE, bgmloop);
			addEventListener(Event.ENTER_FRAME, titleloop);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, titleKeyDown);
		}

		private function titleloop(e:Event):void { // タイトルループ
			coneMan.Move();
			coneMan2.Move();
			coneLog1.Move();
			coneLog2.Move();
			gem.Move();
		}
		
		private function bgmloop(e:Event):void { //タイトルBGMのループ
			//channel = titlebgm.play();
			//channel.addEventListener(Event.SOUND_COMPLETE, bgmloop);
		}

		private function titleKeyDown(event:KeyboardEvent):void {
			 switch (event.keyCode) {
				case  32: 
				default:
					removeEventListener(Event.ENTER_FRAME, titleloop);
					stage.removeEventListener(KeyboardEvent.KEY_DOWN, titleKeyDown);
					scene.removeChild(coneMan2);
					scene.removeChild(coneLog1);
					scene.removeChild(coneLog2);
					scene.removeChild(title_mes1);
					scene.removeChild(title_mes2);
					scene.removeChild(title_mes3);
					//channel.stop();
					//channel.removeEventListener(Event.SOUND_COMPLETE, bgmloop);
			//		scene.addChild(debug_mes);
					scene.addChild(bg);
					scene.addChild(damage);
					scene.addChild(gems_text);					
					scene.addChild(stage_text);
					scene.addChild(lefttime);
					scene.addChild(damage_fl);
					initGame();
					addEventListener(Event.ENTER_FRAME, loop);
					stage.addEventListener(KeyboardEvent.KEY_UP, reportKeyUp);
					stage.addEventListener(KeyboardEvent.KEY_DOWN, reportKeyDown);
				break;
			 }
		}

		private function reportKeyDown(event:KeyboardEvent):void { //キーが押された
			 switch (event.keyCode) {
				 case  Keyboard.RIGHT:  // Push Left
					move_r = 1;
				 break;
				case   Keyboard.LEFT:  // Push Right
					move_l = 1;
				 break;
				case  Keyboard.UP:  // Push Up
					move_u = 1;
				 break;
				case  Keyboard.DOWN:  // Push Down
					move_d = 1;
				break;
				case  32:
					if (gameover.visible) {
						if (over_count > 60) {
							stage_count = 1;
							gems_count = 0;
							removeWalls();
							initGame();
							gameover.visible = false;
							scene.removeChild(gameover);
						}
					} else if (stageclear.visible) {
						if (clear_count > 60) {
							stageclear.visible = false;
							scene.removeChild(stageclear);
							if (stage_count == 5) {
								setEnd();
							} else {
								initGame();
								stage_count++;
							}
						}
					} else if (!is_jump) {
						is_jump = true;
						jump_y= 100;
						//jump_sound.play();
					}
				 break;
				 
				 default:
				 break;
			 }
		}

		private function reportKeyUp(event:KeyboardEvent):void { // キーが離された
			switch (event.keyCode) {
				case  Keyboard.RIGHT:  // Push Left
					move_r = 0;
				 break;
				case   Keyboard.LEFT:  // Push Right
					move_l = 0;
				 break;
				case  Keyboard.UP:  // Push Up
					move_u = 0;
				 break;
				case  Keyboard.DOWN:  // Push Down
					move_d = 0;
				 break;
			}
		}	

		private function stageClear():void {  // ステージクリア
			clear_count++;
			if (stageclear.scale < 1.2) {
				stageclear.scale += 0.05;
			}
			if (stageclear.rotationZ < 720) {
				stageclear.rotationZ += 20;
			}
			coneMan.z += 100;
			coneMan.Move();
		}
		
		private function gameOver():void {//ゲームオーバー
			over_count++;
			if (gameover.scale < 1.2) {
				gameover.scale += 0.05;
			}
			if (coneMan.rotationX < 100) {
				coneMan.rotationX += 3;
			}
			if (coneMan.y > -400) {
				coneMan.y -= 20;
			}		
		}

		private function setEnd():void {//エンディングセット
			//channel = endbgm.play();
			//channel.addEventListener(Event.SOUND_COMPLETE, endloop);

			end_mes.visible = true;
			end_mes.text = "You've got " + gems_count.toString() + " gems!!!";
			scene.addChild(end_mes);
			gems = new Array(gems_count);
			for (var i:int = 0; i < gems_count; i++) {
				gems[i] = new ConeGem();
				gems[i].moveForward(Math.floor(i /8)* 200);
				gems[i].moveLeft(700  - (i - (Math.floor(i /8 )*8)) * 200);
				scene.addChild(gems[i]);
			}
			coneMan.Init();
		}

		private function endloop(e:Event):void { //エンディングループ
			end_mes.visible = false;
			scene.removeChild(end_mes);
			for (var i:int = 0; i < gems_count; i++) {
				scene.removeChild(gems[i]);
			}

			stage_count = 1;
			gems_count = 0;
			initGame(); 
		}

		private function gameEnd():void {//エンディング
			coneMan.MoveEnd();
			for (var i:int = 0; i < gems_count; i++) {
				gems[i].Move();
			}
		}

		private function loop(e:Event):void { // メインループ
			if (end_mes.visible) { // エンディング
				gameEnd();
				return;
			}

			if (gameover.visible) { // ゲームオーバー処理
				gameOver();
				return;
			}

			if (stageclear.visible) { // ステージクリア処理
				stageClear();
				return;
			}

			next_count++;  // 障害物出現処理
			if (next_count > 55 - (stage_count *5)) {
				wall_count++;
				if (wall_count < (stage_count*10) && wall_count < max_walls ) {
						walls[wall_count].visible = true;
				}
				next_count = 0;
			}

			if (is_jump) { // ジャンプ処理
				coneMan.moveUp(jump_y);
				jump_y -= 10;
				if (coneMan.y < -200) {
					coneMan.y = -200;
					is_jump = false;
				}
			} else {
				coneMan.Move();
				coneMan.MoveY();
			}
			
			if (move_r) { // 移動処理
				if (coneMan.position.x < 800) {
					coneMan.moveRight(25);
				}
			}
			if (move_l) {
				if (coneMan.position.x > -800) {
					coneMan.moveLeft(25);
				}
			}
			if (move_d) {
				if (coneMan.position.z > 0) {
					coneMan.moveBackward(25);
				}
			}
			if (move_u) {
				if (coneMan.position.z < 1000) {
					coneMan.moveForward(25);
				}
			}

			damage_fl.visible = false;
			for (var i:int = 0; i < max_walls; i++) { // 障害物の処理
				if (walls[i].visible) {
					walls[i].z -= 50;
					walls[i].Move();
					if (walls[i]. z < -500) {
						walls[i].z = 9000;
					}
					if ((walls[i].isHit(coneMan))) {  // 当たり判定
					    damage_count++;
						damage_fl.visible = true;
						//damage_sound.play();
						damage.text = "Damage : " + damage_count.toString() + "/10";
						if (damage_count > 9) {  // :ゲームオーバー処理
							//gameover_sound.play();
							scene.addChild(gameover);
							gameover.visible = true;
							//channel.stop();
							break;
						}
					}
				}
			}

			gem.z -= 25;
			gem.Move();
			if (gem.z < -500) {
				gem.Init(bg.z);
			}
			if (gem.isHit(coneMan)) {
				//gem_sound.play();
				gem.Init(bg.z);
				gems_count++;
				gems_text.text = "Gems : " + gems_count.toString();
			}
			
			bg.moveBackward(3);// 背景移動
			stage_text.text =  "Stage : " + stage_count.toString() ;
			lefttime.text =  "Time  : " + ((bg.z + 400)/90).toFixed(1).toString();
			if (bg.z <= (5000 - 5400)) {  // ステージクリア処理
				coneMan.y = -200;
				is_jump = false;
				//clear_sound.play();
				scene.addChild(stageclear);
				stageclear.visible = true;
				//channel.stop();
				removeWalls();
			}
			//debug_mes.text = "x = " + coneMan.position.x.toFixed(0) + " , y = " + coneMan.position.y.toFixed(0) + ", z = " + coneMan.position.z.toFixed(0) + ",Ens = " + wall_count.toString();
			// デバッグ用メッセージ
		}
	}
}	

	import flash.events.*;
	import flash.media.*;
	import flash.text.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.core.math.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.materials.shadematerials.*;
	import org.papervision3d.materials.utils.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.typography.*;
	import org.papervision3d.typography.fonts.*;

	class ConeArrow extends DisplayObject3D {   // 障害物「矢印」のクラス
		private var ar:Arrow;

		public function ConeArrow():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x888888);
			ar = new Arrow(mat);
	
			ar.localRotationY = 180;
			ar.moveUp(200);
			super();
			addChild(ar);
			this.x = -800 + 1600 * Math.random();
		}
		
		public function Move():void {
			ar.localRotationZ += 10;
		}

		public function isHit(man:ConeMan):Boolean {
			if ( (this.z -  80) < man.z  && man.z < (this.z + 80) && 
				 (this.x -120) < man.x  && man.x < (this.x + 120)  &&  man.y  > 0) {
				return true;
			}
			return false;
		}
	}
	

	class ConeGem extends DisplayObject3D  {   // お宝ののクラス
		private var gem:Sphere;
		public var a_rot:int = 1;

		public function ConeGem():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFF00);
			gem = new Sphere(mat);
			gem.scaleY = 0.5;
			gem.moveDown(500);

			super();
			addChild(gem);
		}

		public function Move():void{
			gem.localRotationY += a_rot;
		}

		public function Init(bgz:int):void {
			this.z = 5000 + bgz;
			this.x = -800 + 1600*Math.random();
		}
		
		public function isHit(man:ConeMan):Boolean {
			if ( (this.z - 150) < man.z  && man.z < (this.z + 150) && 
				 (this.x -150) < man.x  && man.x < (this.x + 150)  &&  man.y  < - 50) {
				return true;
			}
			return false;
		}
	}
	
	class ConeLog extends DisplayObject3D { // 障害物「丸太」のクラス
		private var log:Cylinder;

		public function ConeLog():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x888888);
			log = new Cylinder(mat, 100, 2000);

			log.rotationZ  = 90;
			log.moveRight(50 - 600);
			
			super();
			addChild(log);
		}

		public function Move():void {
			log.rotationY  += 10;
		}

		public function isHit(man:ConeMan):Boolean {
			if ( (this.z -50) < man.z  && man.z < (this.z + 50)  &&  man.y  < -100  ) {
				return true;
			}
			return false;
		}
	}
	
	class ConeMan extends DisplayObject3D { // コーンマンのクラス
		private var head :ConeManHead;
		private var rightArm:ConeManArm;
		private var leftArm:ConeManArm;
		private var rightLeg:ConeManLeg;
		private var leftLeg:ConeManLeg;
		private var body:Cone;
	    public var a_rot:int = 2;
	    public var move_y:int = 0;

		public var a_ra:int = 2;
		public var a_la:int = -2;
		public var a_rl:int = 2;
		public var a_ll:int = -2;
		public var jump_y:int = 100;
				
		public function ConeMan():void {
			
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x0000FF);
			body = new Cone(mat, 100, 250, 16, 3);
			body.localRotationZ = 180;
		
			head = new ConeManHead();
			head.moveUp(160);

			rightArm = new ConeManArm();
			rightArm.moveRight(130);
			rightArm.moveUp(115);

			leftArm = new ConeManArm();
			leftArm.moveLeft(130);
			leftArm.moveUp(115);

			rightLeg = new ConeManLeg();
			rightLeg.moveRight(55);
			rightLeg.moveDown(80);

			leftLeg = new ConeManLeg();
			leftLeg.moveLeft(55);
			leftLeg.moveDown(80);

			super();
			addChild(body);
			addChild(head);
			addChild(rightArm);
			addChild(leftArm);
			addChild(rightLeg);
			addChild(leftLeg);
			Init();
		}
		
		public function Init():void {
				this,x = 0;
				this.y = -200;
				this.z = 0;
				this.rotationX = 0;
				this.rotationY = 0;
				this.rotationZ = 0;
				leftArm.localRotationZ = 0;
				rightArm.localRotationZ = 0;
				rightLeg.localRotationZ = 0;
				leftLeg.localRotationZ = 0;

				leftArm.localRotationX = -90;
				rightArm.localRotationX = 90;
				rightLeg.localRotationX = -45;
				leftLeg.localRotationX = 45;
		}

		public function Move():void {
			head.Move();	
			rightArm.Move();	
			leftArm.Move();	
			rightLeg.Move();	
			leftLeg.Move();	
		}
	
		public function MoveY():void {
			if (this.position.y > -200+ 18) {
				a_rot *= -1;
			}
			if (this.position.y < -200-18) {
				a_rot *= -1;
			}
			if (a_rot < 0) {
				this.moveDown(2);
			}
			if (a_rot > 0) {
				this.moveUp(2);
			}
		}
		
		public function MoveEnd():void {
				
			leftArm.localRotationX =  0;
			rightArm.localRotationX = 0;
			rightLeg.localRotationX =  0;
			leftLeg.localRotationX = 0;
			this.rotationY += 2;
				
			head.Move();
			if (leftArm.localRotationZ > 180) {
				a_la *= -1;
			}
			if (leftArm.localRotationZ < 0) {
				a_la *= -1;
			}
			if (a_la < 0) {
				leftArm.localRotationZ -= 20;
			}
			if (a_la > 0) {
				leftArm.localRotationZ += 20;
			}

			if (rightArm.localRotationZ > 0) {
				a_ra *= -1;
			}
			if (rightArm.localRotationZ < -180) {
				a_ra *= -1;
			}
			if (a_ra < 0) {
				rightArm.localRotationZ -= 20;
			}
			if (a_ra > 0) {
				rightArm.localRotationZ += 20;
			}

			if (leftLeg.localRotationZ > 45) {
				a_ll *= -1;
			}
			if (leftLeg.localRotationZ < 0) {
				a_ll *= -1;
			}
			if (a_ll < 0) {
				leftLeg.localRotationZ -= 5;
			}
		    if (a_ll > 0) {
				leftLeg.localRotationZ += 5;
			}

			if (rightLeg.localRotationZ > 0) {
				a_rl *= -1;
			}
			if (rightLeg.localRotationZ < -45) {
				a_rl *= -1;
			}
			if (a_rl < 0) {
				rightLeg.localRotationZ -= 5;
			}
		    if (a_rl > 0) {
				rightLeg.localRotationZ += 5;
			}

			jump_y -= 10;
			this.y += jump_y;
			if (this.y < -200) {
				this.y = -200;
				jump_y = 100;
			}
		}
	}
	
	class ConeManArm extends DisplayObject3D{// コーンマンの腕クラス
	
		public var a_rot:int = 10;

		public function ConeManArm():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFF0000);
			var mat2:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF);
			var sphere:Sphere = new Sphere(mat, 40);
			var cylinder:Cylinder = new Cylinder(mat2, 40, 160);
			cylinder.moveDown(80);
			sphere.moveDown(160+30);

			super();
			addChild(cylinder);
			addChild(sphere);
		}

		public function Move():void {
			if (this.localRotationX > 90) {
				a_rot *= -1;
			}
			if (this.localRotationX < -90) {
				a_rot *= -1;
			}
			this.localRotationX += a_rot;
		}
	}
	
	class ConeManHead extends DisplayObject3D {// コーンマンの頭クラス
		public var a_rot:int = 2;

		public function ConeManHead():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFF00);
			var sphere:Sphere = new Sphere(mat, 80, 16);
			sphere.moveUp(40);

			super();
			addChild(sphere);
		}

		public function Move():void {
			if (this.localRotationX > 0) {
				a_rot *= -1;
			}
			if (this.localRotationX < -36) {
				a_rot *= -1;
			}
			this.localRotationX += a_rot;
		}
	}
	class ConeManLeg extends DisplayObject3D  {// コーンマンの足クラス
		public var a_rot:int = 5;
		
		public function ConeManLeg():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF);
			var mats:MaterialsList = new MaterialsList();
			mats.addMaterial(new FlatShadeMaterial(light, 0xFF0000), "all");
			
            var cube:Cube = new Cube(mats, 40, 100, 40, 1, 1, 1);
			var cylinder:Cylinder = new Cylinder(mat, 30, 240);
			cylinder.moveDown(120);
			cube.moveDown(240+20);
			cube.moveForward(20);

			super();
			addChild(cylinder);
			addChild(cube);
		}

		public function Move():void {
			if (this.localRotationX > 45) {
				a_rot *= -1;
			}
			if (this.localRotationX < -45) {
				a_rot *= -1;
			}
			this.localRotationX += a_rot;
		}
	}
	
	class ConeNeedle extends DisplayObject3D {// 障害物「ニードル」のクラス
		private var needle:Cone;
					
		public function ConeNeedle():void {
			var light:PointLight3D = new PointLight3D();
			var mat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x888888);
			needle = new Cone(mat, 100, 300);

			needle.moveUp(150 - 600);

			super();
			addChild(needle);
			this.x = -800 + 1600*Math.random();
		}

		public function Move():void {
			//needle.localRotationY = + 10;
		}
		
		public function isHit(man:ConeMan):Boolean {
			if ( (this.z -  80) < man.z  && man.z < (this.z + 80) && 
				 (this.x -120) < man.x  && man.x < (this.x + 120)  &&  man.y  < - 50) {
				return true;
			}
			return false;
		}
	}
	
	class ConeWall extends DisplayObject3D { // 障害物「壁」のクラス
		private var wall:Cube;
		
		public function ConeWall():void {
			var light:PointLight3D = new PointLight3D();
			var mats:MaterialsList = new MaterialsList();
			mats.addMaterial(new FlatShadeMaterial(light, 0x888888), "all");
			wall = new Cube(mats, 150, 150, 1000, 1, 1, 1);

			super();
			addChild(wall);
			this.x = -800 + 1600*Math.random();
		}

		public function Move():void {
			//wall.localRotationY =+ 10;
		}
		
		public function isHit(man:ConeMan):Boolean {
			if ( (this.z -100) < man.z  && man.z < (this.z + 100) && 
				 (this.x -150) < man.x  && man.x < (this.x + 150) ) {
				return true;
			}
			return false;
		}
	}
	