/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c5mk
 */

//PV3DのTriangleMesh3Dの練習01　三角形の作成
//つい最近、Papervision3DのTriangleMesh3Dというものを知ったので、それを使ってみるテストです。
//あまり内部の構造わかってませんが、とりあえず動くまでを。。。
//
//↓今回のコードを作成するにあたって以下のサイト＆コードを参考にさせて頂きました
//TriangleMesh3D Create your own mesh(英語)
//http://pv3d.org/2008/12/13/trianglemesh3d-create-your-own-mesh/
//Papervision3Dでプリミティブ以外のオブジェクトを作る
//http://www.adamrocker.com/blog/141/papervision3d_mesh3d_triangle_object.html
package
{
    import flash.events.Event;

    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.view.BasicView;

    [SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
    public class TriangleMesh3DExample extends BasicView
    {
        private var triangleMesh3d : TriangleMesh3D;
        private var size : int = 200;//オブジェクトの長さ

        public function TriangleMesh3DExample()
        {
            //マテリアル設定
            var material:ColorMaterial = new ColorMaterial(0xcccccc,1.0);
            material.name = "white";
            material.doubleSided = true;

            //頂点
            var vertex3D_1:Vertex3D = new Vertex3D(size*cos(90), size*sin(90), 0);
            var vertex3D_2:Vertex3D = new Vertex3D(size*cos(210), size*sin(210), 0);
            var vertex3D_3:Vertex3D = new Vertex3D(size*cos(330), size*sin(330), 0);

            var triangleVertices:Array = [vertex3D_1, vertex3D_2, vertex3D_3];

            //use null because we haven't created its parent mesh yet            
            var triangle3d:Triangle3D = new Triangle3D(null, triangleVertices, material);
            var triangleFaces:Array = [triangle3d];

            //メッシュを作成
            triangleMesh3d = new TriangleMesh3D(material, triangleVertices, triangleFaces, null);
            //for the triangle to be "renderable", it needs to know who its daddy is
            //this is the same property as the "null" parameter a few lines above
            triangle3d.instance = triangleMesh3d;

            scene.addChild(triangleMesh3d);
            startRendering();
        }

        override protected function onRenderTick(event:Event=null):void
        {
            triangleMesh3d.rotationX=viewport.mouseX;
            triangleMesh3d.rotationY=viewport.mouseY;
            super.onRenderTick(event);
        }

        //--------------------------------------------sin
        private function sin(degree:Number):Number{
            return Math.sin(Math.PI * degree / 180);
        }
 
        //--------------------------------------------cos
        private function cos(degree:Number):Number{
            return Math.cos(Math.PI * degree / 180);
        }
    }
}