/**
 * Copyright gogo178 ( http://wonderfl.net/user/gogo178 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c5Ig
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    public class Main extends Sprite
    {
        private var bone:Bone;
        private var circleA:Circle;
        private var circleB:Circle;
        
        public function Main ()
        {
            // write as3 code here..
            
            circleA = new Circle(0xFF0000);
            circleA.x = stage.stageWidth * 0.25;
            circleA.y = stage.stageHeight * 0.5;
            addChild(circleA);
            
            circleB = new Circle(0x00FF00);
            circleB.x = stage.stageWidth * 0.75;
            circleB.y = stage.stageHeight * 0.5;
            addChild(circleB);
            
            bone = new Bone();
            bone.rotationX = 0;
            bone.x = stage.stageWidth * 0.5;
            bone.y = stage.stageHeight * 0.5;
            addChild(bone);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onEnterFrame (event:Event):void
        {
            var x:Number = circleB.x - circleA.x;
            var y:Number = circleB.y - circleA.y;
            var z:Number = circleB.z - circleA.z;
            var radians:Number;
            
            radians = Math.atan2(z, 1);
            
            // bone.rotationY = radians * (180 / Math.PI);
            radians = Math.atan2(y, x);
            bone.rotationZ = radians * (180 / Math.PI);
            bone.x = circleA.x;
            bone.y = circleA.y;
        }
        
        private function onClick (event:MouseEvent):void
        {
            if (mouseY > stage.stageHeight * 0.5) {
                circleB.z += 5;
            } else {
                circleB.z -= 5;
            }


        }

    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
class Circle extends Sprite
{
    public function Circle (color:int)
    {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, 30);
        graphics.endFill();
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    private function onMouseDown (event:MouseEvent):void
    {
        startDrag();
    }
    
    private function onMouseUp (event:MouseEvent):void
    {
        stopDrag();
    }
}

import flash.display.Sprite;
class Bone extends Sprite
{
    public function Bone ()
    {
        mouseEnabled = false;
        graphics.beginFill(0xFFFFFF * Math.random());
        // graphics.drawCircle(0, 0, 100);
        
        graphics.lineTo(15, -15);
        graphics.lineTo(100, 0);
        graphics.lineTo(15, 15);
        graphics.endFill();
    }
}

