/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c4mP
 */

package {
    import flash.text.TextField;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
           
           deb = new TextField();
           deb.width=320;deb.height=240;
           deb.mouseEnabled=false;
           addChild(deb);
           
           stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
           stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
           stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public function onKdown(e:KeyboardEvent):void    { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void      { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
                
        public var deb:TextField;
        
        public var cx:Number = 230;
        public var cy:Number = 230;
        public var ca:Number = 0;
        public var cp:Number = 0;
        public var ka:Number = 0;
        public var vx:Number = 0;
        public var vy:Number = 0;
        
        public var wx:Number = 200;
        public var wy:Number = 230;
        public var wr:Number = 32;
        
        public function angDiff(a:Number, b:Number):Number
        { a -= b;      if (a > 3.14) { a -= 6.28; }      if (a < -3.14) { a += 6.28;}      return a;  }
        
        public function onEnter(e:Event):void
        {
            cp = ca;
             ca = Math.atan2(cy-wy,cx-wx);
             ka += angDiff(ca,cp);
        
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            graphics.drawCircle(cx,cy,16);
            graphics.moveTo(cx,cy);
            graphics.lineTo(cx+Math.cos(ca)*12, cy+Math.sin(ca)*12);
            
            var d:Number; var t:Number;
            d = angDiff(ka,ca);
            t= 1.4;
            //deb.text = " " +d + "\n " + (1-d);
            if (d > t) { ka+= (t-d); }
            if (d < -t) { ka+= (-t-d); }
            

                     
            graphics.moveTo(cx,cy);         
            graphics.lineTo(cx+Math.cos(ka)*16, cy+Math.sin(ka)*16);
          
           
           var ms:Number; 
             ms =0.1; 
            if (isKeyDown(Keyboard.UP))   { vx += Math.cos(ka)*ms; vy+=Math.sin(ka)*ms; }
            if (isKeyDown(Keyboard.DOWN))   { vx += Math.cos(ka)*-ms; vy+=Math.sin(ka)*-ms; }
            if (isKeyDown(Keyboard.LEFT)) { ka -=0.1; }
            if (isKeyDown(Keyboard.RIGHT)) { ka +=0.1; } 
            
            vx *= 0.98; vy *= 0.98;
            
            cx += vx; cy += vy;
            wx +=vx*0.5; wy+=vy*0.5;
            
            var mag:Number;
            var dx:Number; var dy:Number;
            dx= wx-cx; dy=wy-cy;
            mag = Math.sqrt(dx*dx+dy*dy);
            if (mag==0){mag=0.001;}
            dx/=mag; dy/=mag;
            mag = wr-mag;
            dx*=mag; dy*=mag;
            wx += dx*0.5;
            wy += dy*0.5;
            
            graphics.drawCircle(wx,wy,16);
            
        }//onenter
        
    }//classend
}


