/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c4Et
 */

package {

    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.MouseEvent;//

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var loader:FileLoader;
        private var loadBtn:Btn;
        private var bitmap:Bitmap;

        public function Main() {
            Wonderfl.capture_delay(10);
            init();
        }

        private function init():void {
            graphics.beginFill(0xCCCCCC);
            graphics.drawRect(22, 6, 420, 420);
            graphics.beginFill(0x000000);
            graphics.drawRect(32, 16, 400, 400);
            graphics.endFill();
            loader = new FileLoader();
            loader.addEventListener(Event.INIT, initialize, false, 0, true);
            loadBtn = new Btn();
            addChild(loadBtn);
            loadBtn.x = 232;
            loadBtn.y = 445;
            loadBtn.init({label: "load"});
            loadBtn.addEventListener(MouseEvent.CLICK, load, false, 0, true);
            var bitmapData:BitmapData = new BitmapData(400, 400, true, 0xFF000000);
            bitmap = new Bitmap(bitmapData);
            addChild(bitmap);
            bitmap.x = 32;
            bitmap.y = 16;
        }
        private function load(evt:MouseEvent):void {
            loader.load();
        }
        private function initialize(evt:Event):void {
            bitmap.bitmapData = evt.target.bitmapData;
            bitmap.scaleX = bitmap.scaleY = 1;
            var bw:Number = 400/bitmap.width;
            var bh:Number = 400/bitmap.height;
            var scale:Number = Math.min(bw, bh);
            bitmap.scaleX = bitmap.scaleY = scale;
            bitmap.x = uint(400 - bitmap.width)/2 + 32;
            bitmap.y = uint(400 - bitmap.height)/2 + 16;
        }

    }

}


//////////////////////////////////////////////////
//    FileLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.net.FileReference;
import flash.net.FileFilter;
import flash.display.Loader;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.DataEvent;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class FileLoader extends EventDispatcher {
    private var file:FileReference;
    private static var typeFilter:Array;
    public var data:*;
    private var loader:Loader;
    public var bitmapData:BitmapData;

    public function FileLoader() {
        init();
    }

    private function init():void {
        file = new FileReference();
        file.addEventListener(Event.SELECT, select, false, 0, true);
        file.addEventListener(Event.CANCEL, cancel, false, 0, true);
        file.addEventListener(Event.OPEN, open, false, 0, true);
        file.addEventListener(ProgressEvent.PROGRESS, progress, false, 0, true);
        file.addEventListener(Event.COMPLETE, complete, false, 0, true);
        file.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        file.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        file.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        var fileFilter:FileFilter = new FileFilter("画像ファイル", "*.jpg;*.gif;*.png");
        typeFilter = [fileFilter];
        loader = new Loader();
           loader.contentLoaderInfo.addEventListener(Event.INIT, initialize, false, 0, true);
    }
    public function load():void {
        file.browse(typeFilter);
    }
    private function select(evt:Event):void {
        file.load();
        dispatchEvent(evt);
    }
    private function cancel(evt:Event):void {
        dispatchEvent(evt);
    }
    private function open(evt:Event):void {
        dispatchEvent(evt);
    }
    private function progress(evt:ProgressEvent):void {
        dispatchEvent(evt);
    }
    private function complete(evt:Event):void {
        data = evt.target.data;
        loader.loadBytes(data);
        dispatchEvent(evt);
    }
    private function ioerror(evt:IOErrorEvent):void {
        dispatchEvent(evt);
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(evt);
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(evt);
    }
    private function initialize(evt:Event):void {
        bitmapData = null;
        var bitmap:Bitmap = Bitmap(evt.target.content);
        bitmapData = bitmap.bitmapData;
        dispatchEvent(evt);
    }

}


//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
