/**
 * Copyright masatch ( http://wonderfl.net/user/masatch )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c3Yb
 */

// forked from 9re's Controling Tweens by Easing Functions
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    import gs.easing.*;
    import gs.TweenLite;
    
    [SWF(frameRate="47")]
    public class EasingFonts extends Sprite {
        private var _arr:Array = [];
        private var _originalY:int;
        
        public function EasingFonts() {
            var msg:String = "Easing Function Test";
            
            var tfm:TextFormat = new TextFormat("Arial", 20, 0x666666, true);
            
            var tfOriginal:TextField = new TextField();
            tfOriginal.defaultTextFormat = tfm;
            tfOriginal.autoSize = TextFieldAutoSize.LEFT;
            tfOriginal.width = 0;
            tfOriginal.text = msg;
            
            var tf:TextField;
            _originalY = stage.stageHeight / 2 - 10;
            for (var i:int = 0; i < msg.length; ++i) {
               tf = new TextField();
               tf.defaultTextFormat = tfm;
               tf.text = msg.substr(i, 1);
               tf.selectable = false;
               tf.x = tfOriginal.getCharBoundaries(i).left + (stage.stageWidth - tfOriginal.width) / 2;
               tf.y = _originalY;
               _arr.push(tf);
               addChild(tf);
            }
            
            func0();
        }
        
        private function func0():void {
            var tf:TextField;
            var time:Number, delay:Number;
            var tweenObj:Object;
            var len:int = _arr.length;
            
            for (var i:int = 0; i < len; ++i) {
                tf = _arr[i];
                time = Quad.easeOut(i, 0.3, 0.9, _arr.length);
                delay = Quad.easeOut(i, 0.9, 1.5, _arr.length);
                tweenObj = {y: -30, ease:Back.easeIn, delay: delay};
                
                if (i == _arr.length - 1)
                    tweenObj.onComplete = func1;
                    
                TweenLite.to(tf, time, tweenObj);
            }
        }
        
        private function func1():void {
            var tf:TextField;
            var time:Number, delay:Number;
            var tweenObj:Object;
            var len:int = _arr.length;
            
            for (var i:int = 0; i < _arr.length; ++i) {
                tf = _arr[i];
                
                time = Quad.easeIn(i, 0.3, 0.9, len);
                delay = Quad.easeOut(len - i - 1, 0.9, 1.5, len);
                tweenObj = {y: _originalY, ease:Back.easeOut, delay: delay};
                
                if (i == 0)
                    tweenObj.onComplete = func0;
                    
                TweenLite.to(tf, time, tweenObj);
            }
            
        }
    }
}