/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c3Xp
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var charaChip:BitmapData;
		private const C_WIDTH:int = 32;
		private const C_HEIGHT:int = 48;
 
		private var frame:int = 0;
		private var cx:int = 0;
		private var cy:int = 2;
		private var chara:BitmapData;
 
		private var left:Boolean = false;
		private var right:Boolean = false;
		private var player:Bitmap;
 
		private const SPEED:int = 10;
		private var jump:Boolean = false;
		private var vy:int = 0;
 
		public function Main()
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/3/33/3384/3384200b2dc435c82a6c311375c2e26b81bc80e2"), new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void
		{
			var loader:Loader = event.currentTarget.loader;
			charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
			charaChip.draw(loader);
			charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0x78c380, 0x0, 0xFFFFFF);
 
			chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
			player = new Bitmap(chara);
			player.scaleX = player.scaleY = 2;
			addChild(player);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
 
		private function onEnterFrame(event:Event):void
		{
			if (left) player.x -= SPEED, cy = 1;
			else if (right) player.x += SPEED, cy = 2;
 
			if (jump)
			{
				vy += 2;
				player.y += vy;
 
				if (player.y + player.height > stage.stageHeight)
				{
					player.y = stage.stageHeight - player.height;
					jump = false;
				}
			}
 
			if (frame++ == 0 || (left || right) && frame++ % 3 == 0)
			{
				chara.copyPixels(charaChip, new Rectangle(C_WIDTH * (cx + 6), C_HEIGHT * cy, C_WIDTH, C_HEIGHT), new Point());
				cx = (cx + 1) % 3;
			}
		}
 
		private function onKeyDown(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) left = true;
			if (event.keyCode == 39) right = true;
			if (event.keyCode == 38)
			{
				if (jump) return;
 
				jump = true;
				vy = -20;
			}
		}
 
		private function onKeyUp(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) left = false;
			if (event.keyCode == 39) right = false;
		}
	}
}
