/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c3Lv
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Collision extends Sprite
    {
        internal var bodyList :Array = [];
        
        public function Collision()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            for (var $index:Number = 0; $index < 25; $index++)
                {bodyList[$index] = new Body(Math.random()*465, Math.random()*465)}
        }
        
        public function _init() :void
        {
            for (var $index:Number = 0; $index < bodyList.length; $index++)
                {addChild(bodyList[$index])} 

            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        { 
            _init();
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame($e:Event) :void
        {
            for (var $index:Number = 0; $index < bodyList.length; $index++)
                {if (($index + 1) < bodyList.length)
                { 
                    for (var $i:Number = 0; $i < bodyList.length; $i++)
                    {if (bodyList[$i] != bodyList[$index])
                        { solveCollision(bodyList[$index], bodyList[$i])}}}
                }
        }
        
        public function solveCollision($body1:Object, $body2:Object) :void
        {
            var $sum   :Number = ($body1.radius + $body2.radius);
            var $distX :Number = ($body2.x - $body1.x);
            var $distY :Number = ($body2.y - $body1.y);        
            var $dist  :Number = Math.sqrt(($distX * $distX) + ($distY * $distY));
            
            if ($dist < $sum)
            {
                var $forceX :Number = ($distX / $dist);
                var $forceY :Number = ($distY / $dist);
                var $force  :Number = ($dist - $sum);
                
                $body1.x += $forceX * $force;
                $body1.y += $forceY * $force;
                $body2.x -= $forceX * $force;
                $body2.y -= $forceY * $force;
            }
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class Body extends Sprite
{
    protected var _c:Number;
    protected var _a:Number;
    protected var _x:Number;
    protected var _y:Number;
    protected var _r:Number;
    
    internal var   g:Number = 0; //initialize gravity
    internal const v:Number = 1; //increment velocity of gravity

    public function Body($x:Number = 232.5, $y:Number = 232.5, $r:Number = 12, $c:Number = 0, $a:Number = 0.75)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _c = $c;
        _a = $a;
        _x = $x;
        _y = $y;
        _r = $r;
    }
    
    public function _init() :void
    {
        graphics.clear      ();
        graphics.beginFill  (_c, _a);
        graphics.drawCircle (_x, _y, _r);
        graphics.endFill    ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function onEnterFrame($e:Event) :void
    {
        if  (!stage.hasEventListener(MouseEvent.MOUSE_MOVE))
            {simGravitate()}
    }
    
    public function simGravitate() :void
    {
        if   ((y + (g + v)) < (464 - radius))       //if next increment < floor
             { g = (g < 40) ? (g + 2) : g; y += g}  //apply increment while < terminal velocity
        else { y = (464 - radius); g = 0; }         //else snap to floor & reset g
    }

    internal var oldPt :Point;
    internal var newPt :Point;
    internal var clcPt :Point;
    
    public function onMouseDown($e:MouseEvent) :void
    {
        oldPt = new Point($e.stageX, $e.stageY);
        
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        newPt = new Point($e.stageX, $e.stageY);
        clcPt = Point(newPt.subtract(oldPt));
        
        x = (x + clcPt.x);
        y = (y + clcPt.y);
        
        oldPt = newPt;
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    public override function get x() :Number
    { return _x }
    
    public override function get y() :Number
    { return _y }
    
    public override function get alpha() :Number
    { return _a }
    
    public function get color() :Number
    { return _c }
    
    public function get radius() :Number
    { return _r }
    
    public override function set x($value:Number) :void
    { _x = $value; _init(); }
    
    public override function set y($value:Number) :void
    { _y = $value; _init(); }
    
    public override function set alpha($value:Number) :void
    { _a = $value; _init(); }
    
    public function set color($value:Number) :void
    { _c = $value; _init(); }
    
    public function set radius($value:Number) :void
    { _r = $value; _init(); }
}
