/**
 * Copyright nondelion ( http://wonderfl.net/user/nondelion )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c3Ky
 */

// forked from muta244's [最適化 Tips] 変数名の長さによる処理速度の違い
package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 1000000;
    
    private var ary:Array = [
                                1, 0, 0, 0, 0,
                                0, 1, 0, 0, 0,
                                0, 0, 1, 0, 0,
                                0, 0, 0, 1, 0
                            ];
    private var ary2:Array = [
                                1, 0, 0, 0, 255,
                                0, 1, 0, 0, 255,
                                0, 0, 1, 0, 255,
                                0, 0, 0, 1, 0
                            ];
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("配列の要素を1つ変更", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary[4] = 255;
            }
        });
        
        _measure("配列の要素を2つ変更", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary[4] = 255;
                ary[9] = 255;
            }
        });
        
        _measure("配列の要素を3つ変更", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary[4] = 255;
                ary[9] = 255;
                ary[14] = 255;
            }
        });
        
        _measure("配列の要素を全て変更", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary[0] = 1;
                ary[1] = 0;
                ary[2] = 0;
                ary[3] = 0;
                ary[4] = 255;
				ary[5] = 0;
                ary[6] = 1;
                ary[7] = 0;
                ary[8] = 0;
                ary[9] = 255;
				ary[10] = 0;
                ary[11] = 0;
                ary[12] = 1;
                ary[13] = 0;
                ary[14] = 255;
				ary[15] = 0;
                ary[16] = 0;
                ary[17] = 0;
                ary[18] = 1;
                ary[19] = 0;
            }
        });
        
        _measure("事前に作成した配列の代入", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary = ary2;
            }
        });
        
        _measure("新しく配列を作成する（[]）", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary = [
                        1, 0, 0, 0, 255,
                        0, 1, 0, 0, 255,
                        0, 0, 1, 0, 255,
                        0, 0, 0, 1, 0
                      ];
            }
        });
        
        _measure("新しく配列を作成する（new Array()）", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                ary = new Array(
                        1, 0, 0, 0, 255,
                        0, 1, 0, 0, 255,
                        0, 0, 1, 0, 255,
                        0, 0, 0, 1, 0
                      );
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
