/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c3Hv
 */

package {
  import flash.display.Sprite;
  public class ch21ex7 extends Sprite {
    public function ch21ex7() {
      var leftEye:Eye = new Eye(60);
      var rightEye:Eye = new Eye(60);
      leftEye.y = rightEye.y = stage.stageHeight/2;
      leftEye.x = stage.stageWidth * 1/3
      rightEye.x = stage.stageWidth * 2/3;
      addChild(leftEye);
      addChild(rightEye);
    }
  }
}
import flash.display.*;
import flash.events.*;
class Eye extends Sprite {
  protected var pupil:Shape;
  public function Eye(size:Number) {
    graphics.lineStyle(3);
    graphics.beginFill(0xffffff);
    graphics.drawCircle(0, 0, size);
    graphics.endFill();
    
    pupil = new Shape();
    addChild(pupil);
    pupil.graphics.lineStyle();
    pupil.graphics.beginFill(0x603030);
    pupil.graphics.drawCircle(3/4 * size, 0, size/4);
    
    scaleY = 2;
    addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
  }
  protected function onAddedToStage(event:Event):void {
    stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
  }
  protected function onMouseMove(event:MouseEvent):void {
    pupil.rotation = Math.atan2(this.mouseY, this.mouseX) / Math.PI * 180;
    event.updateAfterEvent();
  }
}