/**
 * Copyright hacker_9lmfzt_3 ( http://wonderfl.net/user/hacker_9lmfzt_3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c3DF
 */

// forked from miyaoka's Fireworks
package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*
	import caurina.transitions.Tweener;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	
	[SWF(width = "465", height = "465", backgroundColor = 0xf, frameRate = "60")]
	
	public class CircleFlower extends Sprite 
	{
		public function CircleFlower():void 
		{
			graphics.beginFill(0);
			graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			
			
			var timer:Timer = new Timer(100);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function():void
			{
				fire(null);
				timer.addEventListener(TimerEvent.TIMER, fire);
				timer.start();
			});
			stage.addEventListener(MouseEvent.MOUSE_UP, function():void
			{
				timer.removeEventListener(TimerEvent.TIMER, fire);
				timer.stop();
			});
		}
		private function fire(e:Event):void 
		{

			var c:Sprite= new Sprite();
			c.blendMode = BlendMode.ADD;
			c.x = mouseX;
			c.y = stage.stageHeight //mouseY + (Math.random() * 0.5 + 1) * 800;
			var radius:Number = (Math.random() *5.0 + 1) * 10;
			var g:Graphics = c.graphics;
			g.beginFill(Math.random() * 0xffcccc);
			g.drawCircle(0, 0, radius);
			c.scaleX = c.scaleY = 0.01;
			c.rotation = Math.random() * 360;
			
			addChild(c);
			
			Tweener.addTween(c, {
				scaleX: 1,
				scaleY: 1,
				y: mouseY,
				time: 1.0,
				transition: "easeInExpo",
				onComplete: function ():void 
				{
					var t:Number = 0;
					var pt:Point;
					g.clear();
					
					while (360 > t)
					{
						var piesT:Number = Math.min(360-t, Math.random() * 30 + 20);
						var pieT:Number = (Math.random() * 0.2 + 0.7) * piesT;
						
						var p1:Pie = new Pie(radius, pieT * Math.PI / 180, 0xFFFFFF *Math.random());
						p1.rotation = t;
						
						pt = Point.polar(radius * (Math.random() * 3.0 + 1.0) * 1.0, (p1.rotation + pieT/2) * Math.PI / 180);
						Tweener.addTween(p1, {
							x: pt.x,
							y: pt.y,
							time:Math.random() * 2.0 + 1.0
						});
						
						var p2:Pie = new Pie(radius * 1.0, (piesT- pieT) * Math.PI / 180 ,  0xFFFFFF *Math.random());
						p2.rotation = t + pieT;

						pt = Point.polar(radius * (Math.random() * 1.0 + 1.0) * 0.5, (p2.rotation + (piesT- pieT)/2) * Math.PI / 180);
						Tweener.addTween(p2, {
							x: pt.x,
							y: pt.y,
							time:Math.random() * 3.0  + 1.0
						});
						
						t += piesT;
						c.addChild(p1);
						c.addChild(p2);
					}
					
					var scale:Number = Math.random() *3+2;
					Tweener.addTween(c, {
						time: 0.4 + Math.random() * 0.2,
						rotation: c.rotation + (Math.random() -0.5) * 30,
						scaleX: scale,
						scaleY: scale,
						y : c.y,
						transition: "easeOutQuart",
						onComplete: function ():void 
						{
							Tweener.addTween(c, {
								scaleX : c.scaleX * 0.8,
								scaleY: c.scaleY * 0.8,
								alpha: 0,
								time:0.2,
								transition: "easeInOutCirc",
								onComplete: function ():void 
								{
									removeChild(c);
								}
							});
						}
					})
				}
			});
		}
	}
}
import flash.display.*;
import flash.events.*;
import flash.geom.*;
import caurina.transitions.Tweener;
class Pie
extends Shape
{
	public static var stepT:Number = Math.PI * 2 / 360 * 5;
	public function Pie(len:Number, theta:Number, clr:uint):void 
	{
		var g:Graphics = graphics;
		g.beginFill(clr);
		
		for (var t:Number = theta; t > 0; t -= stepT)
		{
			var pt:Point = Point.polar(len, t);
			g.lineTo(pt.x, pt.y);
		}
		g.lineTo(len, 0);
		g.lineTo(0, 0);
		g.endFill();

	}
}