/**
 * Copyright hycro ( http://wonderfl.net/user/hycro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c2bm
 */

// forked from hycro's Project Euler #017
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	
	public class ProjectEuler extends Sprite {
		private var _textField:TextField;
		
		public function ProjectEuler() {
			initialize();
			writeAnswer(new Problem018);
		}
		
		private function writeAnswer(problem:AbstractProblem):void {
			var answer:String = problem.getAnswer();
			_textField.appendText(answer);
		}
		
		private function initialize():void {
			_textField = new TextField();
			_textField.width = stage.stageWidth;
			_textField.height = stage.stageHeight;
			addChild(_textField);
			_textField.wordWrap = true;
		}
	}
}

// スペルが間違っていたでござるの巻 orz (Abstruct => Abstract に修正)
class AbstractProblem {
	final public function getAnswer():String {
		var answer:String;
		try {
			answer = solve().toString();
		} catch (err:Error) {
			answer = err.getStackTrace();
		}
		return answer;
	}
	
	protected function solve():Number {
		throw new Error("unsolved");
	}
}

class Problem018 extends AbstractProblem
{
	override protected function solve() : Number {
		var answer:Number;
		
		var data:Array = [
		"75",
		"95 64",
		"17 47 82",
		"18 35 87 10",
		"20 04 82 47 65",
		"19 01 23 75 03 34",
		"88 02 77 73 07 63 67",
		"99 65 04 28 06 16 70 92",
		"41 41 26 56 83 40 80 70 33",
		"41 48 72 33 47 32 37 16 94 29",
		"53 71 44 65 25 43 91 52 97 51 14",
		"70 11 33 28 77 73 17 78 39 68 17 57",
		"91 71 52 38 17 14 91 43 58 50 27 29 48",
		"63 66 04 68 89 53 67 30 73 16 69 87 40 31",
		"04 62 98 27 23 09 70 98 73 93 38 53 60 04 23"];
		
		var nodes:Vector.<Vector.<Node>> = new Vector.<Vector.<Node>>(data.length);
		
		// ノード生成
		for (var i:int = data.length-1; i >= 0; i--) {
			var rowData:Array = String(data[i]).split(" ");
			var rowNodes:Vector.<Node> = new Vector.<Node>();
			for (var j:int = 0; j < rowData.length; j++) {
				if (i != data.length - 1) {
					rowNodes[j] = new Node(parseInt(rowData[j]), nodes[i+1][j], nodes[i+1][j+1]);
				} else {
					rowNodes[j] = new Node(parseInt(rowData[j]));
				}
			}
			nodes[i] = rowNodes;
		}
		
		// 下から2番目の層から順に上位層へ
		for (var depth:int = nodes.length-2; depth >= 0; depth--) {
			// 現在の層の各ノードについて、下位の層のノードのうち値の大きい方を自分自身に加算する
			for each (var node:Node in nodes[depth]) {
				node.value += Math.max(node.left.value, node.right.value);
			}
		}
		
		answer = nodes[0][0].value;
		
		return answer;
	}
}

class Node {
	public var value:uint;
	public var left:Node;
	public var right:Node;
	
	public function Node(value:uint, left:Node=null, right:Node=null) {
		this.value = value;
		this.left = left;
		this.right = right;
	}
}