/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c2Mm
 */

// forked from daniwell's Line Art
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class LineArt extends Sprite {
        
        private var _lines :/*Line*/Array = [];
        
        public function LineArt() { addEventListener(Event.ENTER_FRAME, _enterFrame); }
        
        /* ENTER FRAME */
        private function _enterFrame ( evt :Event ) :void {
            
            // クリア & 背景描画
            graphics.clear();
            graphics.beginFill(0x0); graphics.drawRect(0, 0, 465, 465); graphics.endFill();
            
            // Line 生成
            _lines.push(new Line());
            
            // Line 更新
            for (var i :int = 0; _lines[i]; i++) if (_lines[i].update(graphics)) _lines.splice(i, 1)[0] = null;
        }
    }
}

import flash.display.Graphics;
import flash.utils.getTimer;

class Line {
    /* 分割数 */
    private const SEP :int = 12;
    
    private var _nstart :int;
    private var _nend   :int;
    
    private var _offsetY :int;
    
    private var _dw :Number;
    private var _dh :Number;
    private var _dd :Number;
    
    private var _thick  :int;
    private var _speed :int;
    
    public function Line () {
        _nstart = _nend = 0;
        _offsetY = Math.random() * 465;
        
        _dw = 465 / SEP;
        _dh = Math.random() * 77 + 15;
        _dd = Math.random() * 0.3 + 0.1;
        
        _thick = Math.random() * 4;
        _speed = Math.random() * 200 + 300;
    }
    
    public function update ( g :Graphics ) :Boolean {
        
        if (_nend < SEP) _nend ++; else _nstart ++;
        
        // 終了
        if (SEP == _nstart) return true;
        
        g.lineStyle(_thick, int(Math.random() * 0xffffff), 0.9);
        
        for (var i :int = _nstart; i <= _nend; i ++) {
            var px :int = 465 - _dw * i;
            var py :int = Math.sin(getTimer() / _speed + i * _dd) * _dh + _offsetY;
            
            if (i != _nstart) g.lineTo(px, py); else g.moveTo(px, py);
        }
        return false;
    }
}