/**
 * Copyright IPFix ( http://wonderfl.net/user/IPFix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c29b
 */

/**
 * Simple example of KonamiCode Class
 *
 */ 
package  
{
	import flash.filters.ColorMatrixFilter;
	
	import flash.text.TextField;
	import flash.text.TextFormat;

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.Shape;
	
	import flash.events.Event;
	
	import flash.geom.Rectangle;
	import flash.geom.Point;
	
	[SWF(width = 400, height = 400, backgroundColor = 0x333333)]
	public class Main extends Sprite
	{
		private var bitmapData:BitmapData;
		private var konami:Boolean =false;
		private var matrix:Array;
		private var filter:ColorMatrixFilter;
		private var shape:Shape;
		
		public function Main():void
		{
			
			bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight, true, 0x000000);
			addChild( new Bitmap(bitmapData) );
			
			KonamiCode.add( stage, onKonami );	
			
			shape = new Shape();
			matrix = new Array();
			matrix = matrix.concat([0.7, 0, 0, 0, 0]);  // red
            matrix = matrix.concat([0, 1, 0, 0, 0]);    // green
            matrix = matrix.concat([0, 0, 0.7, 0, 0]);  // blue
            matrix = matrix.concat([0, 0, 0, 0.95, 0]); // alpha
			filter = new ColorMatrixFilter( matrix );
			
			createText();
			
			addEventListener( Event.ENTER_FRAME, everyFrame );
		}
		
		private function createText():void
		{
			var tile_size:int = 32;
			var msgs:Array = ["Konami Code","Top-Top-Down","Down-Left","Right-Left","Right-B-A","Enter"]	;
			var format:TextFormat = new TextFormat("Arial", 16, 0xFFFFFF, true);			
			
			for( var i:int=0; i<msgs.length; i++){
				var msg:Array = String(msgs[i]).split("");
				for( var j:int=0; j<msg.length; j++){
					var tf:TextField = new TextField();
					
					tf.y = 2*i*tile_size+6;
					tf.x = j*tile_size+6;
					tf.selectable = false;
					
					tf.defaultTextFormat = format;
					tf.text = msg[j];
					this.addChild( tf );
				}
			}
		}
		
		private function onKonami():void
		{
			konami = !konami;
		}
		
		private function everyFrame( e:Event ):void
		{
			var tile_size:int = 32;
			var x: int = Math.floor(Math.random()*stage.stageWidth/tile_size)*tile_size;
			var y: int = Math.floor(Math.random()*stage.stageHeight/tile_size)*tile_size;
			
			shape.graphics.clear();
			shape.graphics.beginFill(0xFFFFFF);
			if( !konami )
				shape.graphics.drawRect(x,y,tile_size,tile_size);
			else 
				shape.graphics.drawEllipse(x,y,tile_size,tile_size);
				
			shape.graphics.endFill();
			bitmapData.draw(shape);
			bitmapData.applyFilter( bitmapData, bitmapData.rect, new Point(),filter );
		}
	}		
}

import flash.display.Stage;
import flash.events.EventDispatcher;
import flash.events.KeyboardEvent;
import flash.ui.Keyboard;

/**
 * KonamiCode Class
 *
 * @author David Ronai - Gobelins Student
 * @usage KonamiCode.add( stage, callback );
 */
class KonamiCode extends EventDispatcher
{
	private static var currentTouch:uint = 0;
	private static var callback:Function;
	private static var pushTouch:Array = [
		Keyboard.UP, 
		Keyboard.UP,
		Keyboard.DOWN,
		Keyboard.DOWN,
		Keyboard.LEFT,
		Keyboard.RIGHT,
		Keyboard.LEFT,
		Keyboard.RIGHT,
		66,//B
		65,//A
		Keyboard.ENTER
	];
	
	// - Bad Idea !
	public function KonamiCode() 
	{
		throw( new Error("KonamiCode can't be instanciated, please use 'KonamiCode.add(stage, callback)'"));
	}
	
	/**
	 * Add konami code on your program
	 * 
	 * @param	stage Main Stage
	 * @param	callback Callback function call when konamicode is finish
	 * @usage KonamiCode.add( stage, callback );
	 */
	public static function add( stage:Stage, callback:Function):void 
	{
		if ( stage == null || callback == null )
			return;
		KonamiCode.callback = callback;
		stage.addEventListener(KeyboardEvent.KEY_DOWN, keyHandler);
	}
	
	/**
	 * Check if key is in konami code sequence
	 * 
	 * @param	e keyPressed Event.
	 */
	private static function keyHandler(e:KeyboardEvent):void 
	{
		
		if ( pushTouch[currentTouch] == e.keyCode )
		{
			currentTouch++;
			if ( currentTouch == pushTouch.length )
			{
				callback();
				currentTouch = 0;
			}
		} 
		else 
		{
			currentTouch = 0;
		}
	}
}