/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c1o3
 */

package
{
    import net.hires.debug.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            graphics.clear();
            graphics.lineStyle(1, 0, 0.75);
            graphics.drawRect(0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.buildContext(this);
            
            _init();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;
import flash.ui.*;

class Buffer
{
    //context
    public static var context :Object;
    public static var content :Array;
    
    //children
    public static var outputBuffer :Output;
    public static var ranulaUser :Ranula;
    
    public static function buildContext($context:Object) :void
    {
        outputBuffer = new Output("Ranula Kardo v0");
        ranulaUser = new Ranula();
        
        context = $context;
        content = [outputBuffer, ranulaUser];
        
        for (var $:int = 0; $ < content.length; $++)
            { context.addChild(content[$]) }
    }

}

class Ranula extends Sprite
{
    protected var $x:Number;
    protected var $y:Number;
    protected var $r:Number;
    protected var $c:Number;
    protected var $a:Number;
    protected var $v:Number;
    
    private var accelW :Boolean;
    private var accelS :Boolean;
    private var accelA :Boolean;
    private var accelD :Boolean;
    private var lastAccel :Number;
    private var direction :Number;
    
    
    /********************
     * direction:
     * 1 = up
     * 2 = up + left
     * 3 = up + right
     *
     * 4 = down
     * 5 = down + left
     * 6 = down + right
     ********************/
    
    public function Ranula()
    {
        $x = 232.5;
        $y = 232.5;
        $r = 10;
        $c = 0;
        $a = 0.75;
        $v = 0;
        accelW = accelS = accelA = accelD = false;
        lastAccel = 0;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public function _init() :void
    {
        graphics.clear();
        graphics.lineStyle(($r / 2), $c, 0.33);
        
        graphics.beginFill($c, $a);
        graphics.drawCircle($x, $y, $r);
        graphics.endFill();
    }

    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);   
        
        _init();
        
        stage.addEventListener(KeyboardEvent.KEY_DOWN, W_keyDown);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, S_keyDown);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, A_keyDown);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, D_keyDown);
        stage.addEventListener(KeyboardEvent.KEY_UP, keyUp);
        
        stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function W_keyDown($e:KeyboardEvent) :void
    { if ($e.keyCode == Keyboard.W) {
        accelW = true;
    }}

    public function S_keyDown($e:KeyboardEvent) :void
    { if ($e.keyCode == Keyboard.S) {
        accelS = true;
    }}

    public function A_keyDown($e:KeyboardEvent) :void
    { if ($e.keyCode == Keyboard.A) {
        accelA = true;
    }}
    
    public function D_keyDown($e:KeyboardEvent) :void
    { if ($e.keyCode == Keyboard.D) {
        accelD = true;
    }}
    
    public function keyUp($e:KeyboardEvent) :void
    {
        updateDirection();
        
        switch ($e.keyCode)
        {
            case Keyboard.W:
                accelW = false;
                break;
            case Keyboard.S:
                accelS = false;
                break;
            case Keyboard.A:
                accelA = false;
                break;
            case Keyboard.D:
                accelD = false;
                break;
        }
    }
    
    public function updateDirection() :void
    {
        if (accelW && !accelA && !accelD)
        {
            direction = 1;
        }
        else if (accelW && accelA && !accelD)
        {
            direction = 2;
        }
        else if (accelW && !accelA && accelD)
        {
            direction = 3;
        }
        else
        {
            direction = 0;
        }

        if (accelS && !accelA && !accelD)
        {
            direction = 4;
        }
        else if (accelS && accelA && !accelD)
        {
            direction = 5;
        }
        else if (accelS && !accelA && accelD)
        {
            direction = 6;
        }

        if (accelA && !accelW && !accelS && !accelD)
        {
            direction = 7;
        }
        else if (accelD && !accelW && !accelS && !accelA)
        {
            direction = 8;
        }
    }
    
    public function onEnterFrame($e:Event) :void
    {
        if (accelW)
        {
            velocity += (velocity <= 1.75) ? 0.025 : 0;
            y-=velocity;
        }
        if (accelS)
        {
            velocity += (velocity <= 1.75) ? 0.025 : 0;
            y+=velocity;
        }
        if (accelA)
        {
            velocity += (velocity <= 1.75) ? 0.025 : 0;
            x-=velocity;
        }
        if (accelD)
        {
            velocity += (velocity <= 1.75) ? 0.025 : 0;
            x+=velocity;
        }

        if (!accelW && !accelS && !accelA && !accelD)
        {
            if (velocity > 0) {velocity -= 0.025}
            
            switch (direction)
            {
                case 1:
                    y-=velocity;
                    break;
                case 2:
                    y-=velocity;
                    x-=velocity;
                    break;
                case 3:
                    y-=velocity;
                    x+=velocity;
                    break;
                case 4:
                    y+=velocity;
                    break;
                case 5:
                    y+=velocity;
                    x-=velocity;
                    break;
                case 6:
                    y+=velocity;
                    x+=velocity;
                    break;
                case 7:
                    x-=velocity;
                    break;
                case 8:
                    x+=velocity;
                    break;
            }
        }
    }
    
    public function get color() :Number
    {return $c}
    public function get radius() :Number
    {return $r}
    public function get velocity() :Number
    {return $v}
    public override function get alpha() :Number
    {return $a}
    public override function get x() :Number
    {return $x}
    public override function get y() :Number
    {return $y}
    
    public function set color($:Number) :void
    {$c = $; _init()}
    public function set radius($:Number) :void
    {$r = $; _init()}
    public function set velocity($:Number) :void
    {$v = $}
    public override function set alpha($:Number) :void
    {$a = $; _init()}
    public override function set x($:Number) :void
    {$x = $; _init()}
    public override function set y($:Number) :void
    {$y = $; _init()}
}

class Output extends TextField
{
    private var textFormat :TextFormat;
    
    protected var _content :String;
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _content = $content;
        _x = $x;
        _y = $y;
        _font = $font;
        
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function _init() :void
    {
        text = _content;
        x = _x;
        y = _y;
        
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
    
    public function addedToStage($e:Event) :void
    {
       removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
       
       _init(); 
    }
    
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
    
    public function set font($:String) :void
    { _font = $; _init(); }
    public function set content($:String) :void
    { _content = $; _init(); }
}