/**
 * Copyright shaneGirish ( http://wonderfl.net/user/shaneGirish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c1a9
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    import flash.system.fscommand;
    
    // Union - For enabling MultiPlayer Fuctionality
    import net.user1.reactor.*;
    import net.user1.logger.Logger;
    
    // SiON - For enabling proccessing of sounds
    import org.si.sion.*;
    import org.si.sion.events.*;
    import org.si.sion.sequencer.SiMMLTrack;
    import org.si.sion.utils.SiONPresetVoice;
    
    // PV3D - The 3D component
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.special.*;
    
    // The settings of the output
    [SWF(width = "800", height = "600", backgroundColor = "0", frameRate = 90)]
    
    public class Main extends Sprite
    {
        static private const USER_COLOR:uint = Math.random() * 0xFF0000;
        static private const MATRIX_NUM:int = 16;
        static private const DEF_COLOR:int = 0x555555;
        static private const ACTIVE_COLOR:int = 0xEEEEEE;
        static private const OVER_COLOR:int = 0x999999;
            
        //-----------------------------------
        // Union
        //-----------------------------------
        protected var reactor:Reactor;
        protected var room:Room;
        
        // driver
        public var driver:SiONDriver = new SiONDriver();
        
        // preset voice
        public var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        
        // voices, notes and tracks
        public var tracks:Vector.<SiMMLTrack> = new Vector.<SiMMLTrack>(16);
        public var voices:Vector.<int> = Vector.<int>([ 0, 1, 2, 3,  4, 4, 4, 4,  4, 4, 4, 4,  4, 4, 4, 4]);
        public var notes:Vector.<int>  = Vector.<int>([36,48,60,72, 43,48,55,60, 65,67,70,72, 77,79,82,84]);
        
        // beat counter
        public var beatCounter:int;
        
        
        //-----------------------------------
        // PV3d
        //-----------------------------------
        private var world:BasicView = new BasicView(800, 600, false, true);
        private var light:PointLight3D = new PointLight3D();
        private var cubes:Array = [];
        private var logicMatrix:Array = [];
        private var oldDispMatrix:Array = [];
        private var dispMatrix:Array = [];
        private var rollOverMatrix:Array = [];
        
        public function Main() {
            stage.quality = StageQuality.HIGH;
            
            setupUnion();
            setupPV3D();
            setupSiON();
            setupUI();
            
            fscommand("fullscreen", "true");
            fscommand ("showmenu", "false");
            
            //Wonderfl.capture_delay( 10 );
        }
        
        //-----------------------------------
        // Union
        //-----------------------------------
        
        private function setupUnion():void
        {
            reactor = new Reactor();
            reactor.addEventListener(ReactorEvent.READY, readyListener);
            reactor.connect("tryunion.com", 9100);
            reactor.getLog().setLevel(Logger.DEBUG);
        }
        
        protected function readyListener (e:ReactorEvent):void
        {
            reactor.getMessageManager().addMessageListener("GIVE_ME_LOG", sendLog);
            reactor.getMessageManager().addMessageListener("THIS_IS_LOG", happyToReceiveLog);
            
            room = reactor.getRoomManager().createRoom("wonderfl.clockmaker.Nayana");
            room.addMessageListener("SOMEONE_CHANGE", changeCellHandler);
            room.addEventListener(RoomEvent.SYNCHRONIZE, onSynchronize);
            room.join();
        }
        
        protected function happyToReceiveLog(from:IClient, data:String):void
        {
            trace(data);
            var arr:Array = data.split(",");
            
            for (var i:int = 0; i < arr.length; i++) 
            {
                var u:int = i % MATRIX_NUM;
                var v:int = Math.floor(i / MATRIX_NUM);
                
                logicMatrix[u][v] = arr[i];
            }
        }
        
        protected function sendLog(from:IClient):void
        {
            var data:Array = [];
            for (var i:int = 0; i < logicMatrix.length; i++) 
                for (var j:int = 0; j < logicMatrix[i].length; j++) 
                    data.push(logicMatrix[i][j]);

            from.sendMessage("THIS_IS_LOG", data.join(","));
        }
        
        private function onSynchronize(e:RoomEvent):void 
        {
            if ( room.getClients().length == 1 ) {
                // do nothing
            } else {
                var topClient:IClient = room.getClients()[0];
                topClient.sendMessage("GIVE_ME_LOG");
            }
        }
        
        protected function sendCellStatus (o:Object):void
        {
            if (!reactor.isReady()) return;
            room.sendMessage("SOMEONE_CHANGE", true, null, o.colorId, o.u, o.v);
        }
        
        protected function changeCellHandler (fromClient:IClient, colorId:uint, u:int, v:int):void
        {
            logicMatrix[u][v] = colorId;
        }
        
        private function setupSiON():void
        {
            driver.setVoice(0, presetVoice["valsound.percus1"]);  // bass drum
            driver.setVoice(1, presetVoice["valsound.percus28"]); // snare drum
            driver.setVoice(2, presetVoice["valsound.percus17"]); // close hihat
            driver.setVoice(3, presetVoice["valsound.percus23"]); // open hihat
            driver.setVoice(4, presetVoice["valsound.bass18"]);
            
            // listen click
            driver.setTimerInterruption(1, _onTimerInterruption);
            driver.setBeatCallbackInterval(1);
            driver.addEventListener(SiONTrackEvent.BEAT, _onBeat);
            driver.addEventListener(SiONEvent.STREAM_START, _onStreamStart);

            // start streaming
            driver.play();
        }
        
        // _onStreamStart (SiONEvent.STREAM_START) is called back first of all after SiONDriver.play().
        private function _onStreamStart(e:SiONEvent) : void
        {
            // create new controlable tracks and set voice
            for (var i:int=0; i<MATRIX_NUM; i++) {
                tracks[i] = driver.sequencer.newControlableTrack();
                tracks[i].setChannelModuleType(6, 0, voices[i]);
                tracks[i].velocity = 64;
            }
            beatCounter = 0;
        }
        
        
        // _onBeat (SiONTrackEvent.BEAT) is called back in each beat at the sound timing.
        private function _onBeat(e:SiONTrackEvent) : void 
        {
            //matrixPad.beat(e.eventTriggerID & 15);
            beat(e.eventTriggerID & MATRIX_NUM - 1);
        }
        
        
        // _onTimerInterruption (SiONDriver.setTimerInterruption) is called back in each beat at the buffering timing.
        private function _onTimerInterruption() : void
        {
            var beatIndex:int = beatCounter & (MATRIX_NUM - 1);
            for (var i:int = 0; i < MATRIX_NUM; i++)
            {
                if (logicMatrix[beatIndex][i] != DEF_COLOR)
                    tracks[i].keyOn(notes[i]);
            }
            
            beatCounter++;
        }
                      
        //-----------------------------------
        // PV3d
        //-----------------------------------
        
        private function setupPV3D():void
        {
            addChild(world);
            world.startRendering();
            
            for (var i:int = 0; i < MATRIX_NUM; i++) 
            {
                cubes[i] = [];
                logicMatrix[i] = [];
                rollOverMatrix[i] = [];
                for (var j:int = 0; j < MATRIX_NUM; j++) 
                {
                    var material:MaterialObject3D = new FlatShadeMaterial(light, DEF_COLOR);
                    //var material:MaterialObject3D = new ColorMaterial(DEF_COLOR);
                    material.interactive = true;
                    var cube:Plane = new Plane(material, 70, 70);
                    cube.x = 80 * (i - MATRIX_NUM / 2);
                    cube.z = 80 * (j - MATRIX_NUM / 2);
                    cube.y = 100;
                    cube.extra = { u:i, v:j };
                    cube.rotationX = 90;
                    cube.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, cubeClickHandler);
                    world.scene.addChild(cube);
                    cubes[i][j] = cube;
                    logicMatrix[i][j] = DEF_COLOR;
                    rollOverMatrix[i][j] = false;
                }
            }
            
            var particleMat:ParticleMaterial = new ParticleMaterial(0xFFFFFF, 1);
            var particles:ParticleField = new ParticleField(particleMat, 500, 5, 6000, 4000, 6000);
            particles.y = -150;
            world.scene.addChild( particles );
            
            dispMatrix = copyArray2(logicMatrix);
            oldDispMatrix = copyArray2(dispMatrix);
            
            light.x = 200;
            light.y = 400;
            light.z = 200;
            
            world.camera.zoom = 1.5;
            world.camera.focus = 200;
            
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function beat(beat16th:int):void 
        {
            for (var i:int = 0; i < dispMatrix.length; i++) 
            {
                for (var j:int = 0; j < dispMatrix[i].length; j++) 
                {
                    if (beat16th == i)
                    {
                        dispMatrix[i][j] = ACTIVE_COLOR;
                        
                        if (logicMatrix[i][j] != DEF_COLOR)
                            dispMatrix[i][j] = uint(logicMatrix[i][j] * 0x666666);
                    }
                    else
                    {
                        dispMatrix[i][j] = logicMatrix[i][j];
                    }
                    
                    if (rollOverMatrix[i][j]) dispMatrix[i][j] = OVER_COLOR;
                }
            }
            
            update();
        }
        
        private function cubeClickHandler(e:InteractiveScene3DEvent):void 
        {
            var u:int = e.target.extra.u;
            var v:int = e.target.extra.v;
            
            if (logicMatrix[u][v] == DEF_COLOR)
            {
                logicMatrix[u][v] = USER_COLOR;
                sendCellStatus( { colorId:USER_COLOR, u:u, v:v } );
            }
            else
            {
                logicMatrix[u][v] = DEF_COLOR;
                sendCellStatus( { colorId:DEF_COLOR, u:u, v:v } );
            }
            
            update();
        }
        
        private function update():void
        {
            var oldTime:Number = getTimer();
            for (var i:int = 0; i < dispMatrix.length; i++) 
            {
                for (var j:int = 0; j < dispMatrix[i].length; j++) 
                {
                    var c:Plane = cubes[i][j];
                    if (dispMatrix[i][j] != oldDispMatrix[i][j])
                    {
                        var material:MaterialObject3D = new FlatShadeMaterial(light, dispMatrix[i][j]);
                        material.interactive = true;
                        c.material = material;
                    }
                }
            }
            
            oldDispMatrix = copyArray2(dispMatrix);
            trace((getTimer() - oldTime) / 1000);
        }
        
        private function copyArray2(arr:Array):Array
        {
            var r:Array = [];
            for (var i:int = 0; i < arr.length; i++) 
            {
                r[i] = arr[i].concat();
            }
            return r;
        }
        
        private var rot:Number = 45;
        private var pitch:Number = 500;
        private function loop(e:Event):void
        {
            rot += 0.1;
            pitch = 500 * Math.sin(getTimer() / 2500) + 900;
            
            world.camera.x = 1000 * Math.sin(rot * Math.PI / 180);
            world.camera.z = 1000 * Math.cos(rot * Math.PI / 180);
            world.camera.y = pitch;
        }
        
        private function setupUI():void
        {
            var bmp:Bitmap = new Bitmap(new BitmapData(20, 20, false, USER_COLOR));
            bmp.x = 145;
            bmp.y = 30;
            addChild(bmp);
            
            var txtFormat:TextFormat = new TextFormat();
            txtFormat.font = "Arial";
            
            var text1:TextField = new TextField();
            text1.selectable = false;
            text1.defaultTextFormat = txtFormat;
            text1.x = 8;
            text1.y = 4;
            text1.height = 150;
            text1.width = 150;
            text1.htmlText = "<font color='#FFFFFF' size='25'>Room 9</font>";
            //text1.autoSize = "left";
            addChild(text1);
            
            var text:TextField = new TextField();
            text.selectable = false;
            text.defaultTextFormat = txtFormat;
            text.x = 8;
            text.y = 30;
            text.width = 150;
            text.htmlText = "<font color='#FFFFFF' size='15'>YOUR COLOR iS </font>";
            //text.autoSize = "left";
            addChild(text);
            
            // BackGround Color
            var bgMatrix:Matrix = new Matrix();
            bgMatrix.rotate(90 * Math.PI / 180);
            graphics.clear()
            graphics.beginGradientFill("linear", [0x332244, 0x000000], [100, 100], [0, 255], bgMatrix);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
    }
}