/**
 * Copyright ongaeshi ( http://wonderfl.net/user/ongaeshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c1TZ
 */

// trace2
//
// 配列、オブジェクト等をきちんとソースコードと同じ状態で表示してくれる
// 改良型 trace です。
//
// 1. rubyのp等と同様に、出力内容が基本的にソースコード上の表記と同じになります
// 2. 配列はネストされていてもきちんと表示されます(通常のtraceはフラットにされてしまいます)
// 3. Object型の場合は保持しているプロパティの内容を表示します。
//
// trace2 ... traceの代わり
// to_s... toStringの代わり
//
// です。
//
// このサンプルから
//
// to_s_array
// to_s_object
// to_s
// trace2
//
// の4つの関数だけ引っ張りだせば他のプログラムでも使えると思います。

package {
	import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;	

    public class FlashTest extends Sprite {
	    private var _textField:TextField;
	
        public function FlashTest() 
        {
        		initText();	
        				
        	    var o:Object;
        	    
        	    drawText("");
        	    drawText("trace2 .. traceよりもちょっとだけ賢いtrace");
		
			drawText("");
			drawText("数値を表示");
	        o = 121;
	        debugDisp(o);
	        
			drawText("");
			drawText("文字列を表示(数値の場合と出力が変わることに注目)");
	        o = "121";
	        debugDisp(o);
		
			drawText("");
			drawText("文字列を表示");
	        o = "This is String.";	       
	        debugDisp(o);
		
			drawText("");
			drawText("配列を表示");
	        o = [1, 2, 3, 4, 5];
	        debugDisp(o);
		
			drawText("");
			drawText("配列を表示(ネスト)");
	        o = [1, 2, [3, 4], 4, 5];
	        debugDisp(o);
	        
			drawText("");
			drawText("Objectの持つプロパティを表示");
	        o = { x:1, y:2 };
	        debugDisp(o);
	        
			drawText("");
			drawText("Objectのプロパティ表示順は構造上不定になる");
	        o = { x:10, y:2, z:112};
	        debugDisp(o);	        
	        
			drawText("");
			drawText("もちろんObjectの中身が配列だったりObjectだとしても大丈夫");
	        o = { x:10, y:[12, 1], z:{a:10, b:3, c:3}};
	        debugDisp(o);
	        
	    }
	    
	    private function initText():void
	    {
           var format:TextFormat = new TextFormat();
            format.size = 15;
            _textField = new TextField();
            _textField.defaultTextFormat = format;
            _textField.x = 10;
            _textField.y = 10;
            _textField.width = 450
            _textField.height = 450
            _textField.text = "";
            addChild(_textField);
	    }
	    
	    private function drawText(text:String):void
	    {
	    	    _textField.appendText(text + "\n");
	    }
	    
	    private function debugDisp(o:Object):void
	    {
	    		drawText(to_s(o));
	    		trace2(o);
	    }

	    static private function to_s_array(array:Object):String
	    {
			var result:String = "";
			result += "[";
			 
			for (var i:int = 0; i < array.length; i++) {
				result += to_s(array[i]) ;
				 
				if (i != array.length - 1)
				result += ", ";
			}
			 
			result += "]";
			 
			return result;
		}
		
		static private function to_s_object(x:Object):String 
		{
			var result:String = "";
			var isSecond:Boolean = false;
			
			result += "{";
			for (var key:String in x) {
				if (isSecond)
					result += ", ";
				else
					isSecond = true;
				
				result += key + ":" + to_s(x[key]);
			}
			result += "}";
			return result;
		}

		static public function to_s(x:Object):String
		{
		  if (x == null)
			return "null";
		  else if (x.constructor === Object)
			return to_s_object(x);
		  else if (x.constructor === Array)
			return to_s_array(x);
		  else if (typeof x == "string")
			return '"' + x + '"';
		  else
			return x.valueOf();
		}
		
		static public function trace2(x:Object):void
		{
			trace(to_s(x));
		}
			
	}
    

}