/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c19t
 */

/**
* WebDesining 2010 年 01 月号の SWF チューニング特集
* ActionScript 編で visible を false にする方法のほうが
* removeChild メソッドを使用した方法よりも高速になる
* と紹介されていた。これに疑問を感じたので検証してみた。
* (メモリ的にはremoveChildのほうが良いと紹介されていたが
*  それは正しいと思うのでスルー)
*
* よい検証方法が思いつかなかったので、結果はどちらもあまり変わらず。
* removeChild のほうが良さそうだけど、いかがでしょう？
*
* 表示/非表示切り替えだけであれば addChild/removeChild より
* visible のほうがコストは低そうですが、
* その意味で記事中にまとめられていたのでしょうか。
*/

package {
    import flash.display.*;
    import flash.events.*;
    import net.hires.debug.*;
    import com.bit101.components.*;
    
    public class FlashTest extends Sprite {
        private var arr:Array = [];
        private var btn0:PushButton;
        private var btn1:PushButton;
        private var btn2:PushButton;
        public function FlashTest() {
            stage.frameRate = 120;
            
            btn0 = new PushButton(this, 10, 10, "no touch", init);
            btn1 = new PushButton(this, 10, 40, "visible=false", init);
            btn2 = new PushButton(this, 10, 70, "removeChild", init);
        }
        
        private function init(e:Event):void
        {
            removeChild(btn0);
            removeChild(btn1);
            removeChild(btn2);
            
            for(var i:int=0; i<100; i++)
            {
                var sp:Sprite = new Sprite();
                for(var j:int=0; j<100; j++)
                {
                    sp.graphics.beginFill(0xFFFFFF * Math.random());
                    sp.graphics.drawCircle(20 * (Math.random() - 0.5), 20 * (Math.random() - 0.5), 10);
                }
                sp.x = 465 * Math.random();
                sp.y = 465 * Math.random();
                arr[i] = sp;
                addChild(sp);
                
                if(e.currentTarget == btn1) sp.visible = false;
                if(e.currentTarget == btn2) removeChild(sp);
            }
            
            addEventListener(Event.ENTER_FRAME, loop);
            
            addChild(new Stats);
        }
        
        private function loop(e:Event):void
        {
            for(var i:int=0; i<arr.length; i++)
            {
                var sp:Sprite = arr[i] ;
                sp.x --;
                if(sp.x < 0)
                    sp.x = 465;
            }
        }
    }
}