/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c0tE
 */

// forked from yprops's DebugText
package {
    import flash.events.Event;
    import flash.utils.Dictionary;
    import flash.display.Sprite;
    import flash.text.TextField;
    public class DebugText extends Sprite {
        public function DebugText() { if(stage) init(); else addEventListener(Event.ADDED_TO_STAGE, init); }
        private function init(ev :Event = null) :void{ removeEventListener(Event.ADDED_TO_STAGE, init);
            addDeb(450, 450);
            
            
            /*
            Dictionary クラスの動作確認。
            ※ for each, for in でアクセスできる。
            ※ null を代入しても参照が消えない。消すなら delete
            ※ null, undefined もキーに使える！
            ※ hasOwnProperty() は キーが Object や Array などだと false 。
            */
            addDebLine("Dictionary の動作確認。");
            
            var dic :Dictionary = new Dictionary(false);
            var obj :Object = {};
            var i :*;
            
            //設定
            dic[obj] = "Objectをキーとする";
            dic[10] = "Numberをキーとする";
            dic["nullを代入する"] = null;
            dic[null] = "nullをキーとする";
            dic[undefined] = "undefinedをキーとする";
            
            //通常アクセス
            addDebLine("\n■通常アクセス");
            addDebLine("dic[obj] = ", dic[obj], "\t\thasOwnProperty", dic.hasOwnProperty(obj));
            addDebLine("dic[10] = ", dic[10], "\t\thasOwnProperty", dic.hasOwnProperty(10));
            addDebLine("dic[\"nullを代入する\"] = ", dic["str"], "\t\t\thasOwnProperty", dic.hasOwnProperty("nullを代入する"));
            addDebLine("dic[null] = ", dic[null], "\t\thasOwnProperty", dic.hasOwnProperty(null));
            addDebLine("dic[undefined] = ", dic[undefined], "\thasOwnProperty", dic.hasOwnProperty(undefined));
            
            //for each
            addDebLine("\n■ for each でのアクセス。全ての値を参照できる。");
            for each(i in dic)addDebLine("→", i);
            
            //for in
            addDebLine("\n■ for in でのアクセス。全てのキーと値を参照できる。");
            for (i in dic)addDebLine(i, "→", dic[i]);
            
            //nullを代入しても消えない。消すなら delete
            addDebLine("\n■ delete dic[obj] を実行");
            delete dic[obj];
            addDebLine("\n■ 再び for in で確認。dic[obj]はない");
            for (i in dic)addDebLine(i, "→", dic[i]);
        }
        
        
        
        //-------------------------------
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n";
                addChild(deb);
        }
        private function addDebLine(...args) :void{
                deb.appendText(args.join(" ") + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}