/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c0oW
 */

package 
{
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    // 
    import com.bit101.components.*;
    /* @author Thy
    * 3D Cube, Wire .. im learning that 3D stuff ^^
    *  
    * rules (crazy):
    * xyz | +1 -.5 | c-s s+c
    *
    * steps (crazy):
    * (XYZ)(XYZ) | abc,rrr,sc | xyzxyzxyz | x y scale
    *
    * more no sense:
    * (x)(0)         y | z
    * (y)(1)     y + z | x
    * (z)(2) y + z + x | y - z
    * 
    */
    public class Main extends Sprite
    {
        
        private var // 3D cene objects
        box:Ob = new Ob(),
        camera:Cam = new Cam();
        
        private var // ui
        slide1:HUISlider,
        slide2:HUISlider,
        slide3:HUISlider,
        slide4:HUISlider,
        slide5:HUISlider;
        
        private const // const degree to radians proportion
        rads:Number = Math.PI / 180;

        public function Main():void
        {
            // camera settings
            camera.z = -150;
            camera.focal = 500;
            camera.offsetX = stage.stageWidth*.5;
            camera.offsetY = stage.stageHeight*.5;
            
            // box
            this.addChild(box);
            // (note that I already added the box to the display list)
            box.points.push(new P(-10,-10,-10));
            box.points.push(new P(-10,-10,10));
            box.points.push(new P(10,-10,-10));
            box.points.push(new P(10,-10,10));
            
            box.points.push(new P(-10,10,-10));
            box.points.push(new P(-10,10,10));
            box.points.push(new P(10,10,-10));
            box.points.push(new P(10,10,10));
            
            // event
            stage.addEventListener(Event.ENTER_FRAME, ef);
            
            // ui
            slide1 = new HUISlider(this, 0,0, "pitch");
            slide2 = new HUISlider(this, 0,20,"yaw ");
            slide3 = new HUISlider(this, 0,40,"roll  ");
            slide4 = new HUISlider(this, 0, 60, "focal length");
            slide1.width = slide2.width = slide3.width = 
                slide4.width = stage.stageWidth;
            slide1.maximum = slide2.maximum = slide3.maximum = 360;
            slide4.maximum = 500;
            slide4.minimum = 11;
            slide1.value = 15;
            slide2.value = 50;
            slide4.value = 30;
            
            // test
            slide5 = new HUISlider(this, 0, 445, "test");
            slide5.maximum = 360;
            slide5.width = 465;
                     
        }
        
        private function ef(e:Event):void
        {
            // rotate the object box, NOT the camera
            box.pitch = slide1.value * rads;
            box.yaw = slide2.value * rads;
            box.roll = slide3.value * rads;
            // angles were in degree, so we get the radians
            
            // set the camera focal length
            camera.focal = slide4.value;
            
            //**// TEST BEGIN
            // camera.yaw = slide5.value * rads;
            //**// TEST ENDS
            
            // do 3D to 2D conversion
            get2D(box, camera);
            // draw the especific box
            draw(box, camera);
        }
        
        private function get2D(ob:Ob = null, cam:Cam = null):void
        {
            // get the 2D coord of all points, incluing the rotation
            var i:int = -1, l:int = ob.points.length, p:P;
            var a1:Number, a2:Number, b1:Number, b2:Number,
                c1:Number, c2:Number;
            var X:Number, Y:Number, Z:Number,
                r1:Number = ob.pitch, 
                r2:Number = ob.yaw,
                r3:Number = ob.roll;
            var sr1:Number = Math.sin(r1),
                cr1:Number = Math.cos(r1),
                sr2:Number = Math.sin(r2),
                cr2:Number = Math.cos(r2),
                sr3:Number = Math.sin(r3),
                cr3:Number = Math.cos(r3);
                
            while(++i < l)
            {
                p = ob.points[i];
                X = p.x - cam.x;
                Y = p.y - cam.y;
                Z = p.z - cam.z;
                
                a1 = cr1*p.y - sr1*p.z; // pitch (x)
                a2 = sr1*p.y + cr1*p.z;
                
                b1 = cr2*a2 - sr2*p.x; // yaw (y)
                b2 = sr2*a2 + cr2*p.x;
                
                c1 = cr3*b2 - sr3*a1; // roll (z)
                c2 = sr3*b2 + cr3*a1;
                
                p.scale = cam.focal / (cam.focal + b1)
                p.X = c1 * p.scale + cam.offsetX;
                p.Y = c2 * p.scale + cam.offsetY;
            }
        }
        
        private function draw(ob:Ob = null, cam:Cam = null):void
        {
            // draw the especific box
            var p:P, g:Graphics = ob.graphics;
            g.clear();
            g.lineStyle(2,2);
            
            g.moveTo(ob.points[0].X, ob.points[0].Y);
            g.lineTo(ob.points[1].X, ob.points[1].Y);
            g.lineTo(ob.points[3].X, ob.points[3].Y);
            g.lineTo(ob.points[2].X, ob.points[2].Y);
            g.lineTo(ob.points[0].X, ob.points[0].Y);
            
            g.moveTo(ob.points[4].X, ob.points[4].Y);
            g.lineTo(ob.points[5].X, ob.points[5].Y);
            g.lineTo(ob.points[7].X, ob.points[7].Y);
            g.lineTo(ob.points[6].X, ob.points[6].Y);
            g.lineTo(ob.points[4].X, ob.points[4].Y);
            
            g.moveTo(ob.points[0].X, ob.points[0].Y);
            g.lineTo(ob.points[1].X, ob.points[1].Y);
            g.lineTo(ob.points[5].X, ob.points[5].Y);
            g.lineTo(ob.points[4].X, ob.points[4].Y);
            g.lineTo(ob.points[0].X, ob.points[0].Y);
            
            g.moveTo(ob.points[3].X, ob.points[3].Y);
            g.lineTo(ob.points[2].X, ob.points[2].Y);
            g.lineTo(ob.points[6].X, ob.points[6].Y);
            g.lineTo(ob.points[7].X, ob.points[7].Y);
            g.lineTo(ob.points[3].X, ob.points[3].Y);
            
            g.moveTo(ob.points[1].X, ob.points[1].Y);
            g.lineTo(ob.points[5].X, ob.points[5].Y);
            g.lineTo(ob.points[7].X, ob.points[7].Y);
            g.lineTo(ob.points[3].X, ob.points[3].Y);
            g.lineTo(ob.points[1].X, ob.points[1].Y);
            
            g.moveTo(ob.points[0].X, ob.points[0].Y);
            g.lineTo(ob.points[4].X, ob.points[4].Y);
            g.lineTo(ob.points[6].X, ob.points[6].Y);
            g.lineTo(ob.points[2].X, ob.points[2].Y);
            g.lineTo(ob.points[0].X, ob.points[0].Y);            
        }
    }
}


import flash.display.Sprite;

class P{
    public var
    x:Number, y:Number = 0, z:Number = 0,
    X:Number = 0, Y:Number = 0, scale:Number = 0;
    
    public function P(x:Number = 0,  y:Number = 0, z:Number = 0,
        X:Number = 0, Y:Number = 0)
    {
        this.x = x; this.y = y; this.z = z;
        this.X = X; this.Y = Y;
    }
}

class Ob extends Sprite{
    public var 
    points:Vector.<P> = new Vector.<P>(),
    pitch:Number = 0, yaw:Number = 0, roll:Number = 0; 
}

class Cam{
    
    public var
    x:Number = 0, y:Number = 0, z:Number = 0,
    pitch:Number = 0, yaw:Number = 0, roll:Number = 0,
    focal:Number = 0, offsetX:Number = 0, offsetY:Number = 0;
}
