/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bx2n
 */

package {
	import com.adobe.serialization.json.JSON;
	import flash.geom.*;
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.system.*;
	import flash.text.*;
	[SWF(backgroundColor='#000000')]
	public class Tussle extends Sprite {
		
		private static const PROXY:String = 'http://5ivestar.org/proxy/';
		private static const EXP:RegExp = /  <a href="http:\/\/wonderfl\.net\/user\/(.+?)" class="user_name" title="\1">\1<\/a>/g;
		private static const BOUNDS:Rectangle = new Rectangle(0, 0, 1500, 0);
		
		private const arch:Vector.<Column> = new Vector.<Column>();
		private var uid:String;
		private var key:String;
		
		public function Tussle() {
			Wonderfl.capture_delay(10);
			uid = loaderInfo.parameters['appId'];
			key = loaderInfo.parameters['open_api_key'];
			
			stage.align = StageAlign.LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			var h:Shape = new Shape();
			h.graphics.beginFill(0x000000);
			h.graphics.drawRect(0, 0, stage.width, stage.height);
			h.graphics.endFill();
			h.graphics.beginFill(0xffffff, 0.125);
			h.graphics.drawRect(0, 43, stage.stageWidth, 6);
			h.graphics.drawRect(0, 416, stage.stageWidth, 6);
			h.graphics.endFill();
			h.graphics.beginFill(0xffffff, 0.5);
			h.graphics.drawRect(0, 49, stage.stageWidth, 1);
			h.graphics.drawRect(0, 415, stage.stageWidth, 1);
			h.graphics.endFill();
			stage.addChild(h);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
			
			arch.push(new Column(new Date(), null));
			addChild(arch[0]);
			
			Security.loadPolicyFile(PROXY + 'crossdomain.xml');
			var ul:URLLoader = new URLLoader();
			ul.addEventListener(Event.COMPLETE, scrape);
			ul.load(new URLRequest(PROXY + 'http://wonderfl.net/users?r=' + Math.random())); // the caching is killing me
		}
		
		private function mouseDown(e:MouseEvent):void {
			startDrag(false, BOUNDS);
		}
		
		private function mouseUp(e:MouseEvent):void {
			stopDrag();
		}
	
		private function scrape(e:Event):void {
			for (var i:int = 0; i < Column.MAX; i++) {
				var m:Object = EXP.exec(e.target.data);
				arch[0].enter(i, m[1]);
			}
			getArchive();
		}
		
		private function getArchive():void {
			var req:URLRequest =  new URLRequest('http://api.wonderfl.net/score/' + uid + '_dev');
			req.method = URLRequestMethod.GET;
			req.data = new URLVariables();
			req.data['api_key'] = key;
			req.data['limit'] = 40;
			var ul:URLLoader = new URLLoader();
			ul.addEventListener(Event.COMPLETE, populate);
			ul.load(req);
		}
		
		private function populate(e:Event):void {
			var response:Object = JSON.decode(e.target.data);
			var col:Column = arch[0];
			var day:int = 0;
			for each (var entry:Object in response['scores']) {
				var score:int = parseInt(entry['score'], 10);
				if ((int) (score / 10) != day) {
					day = score / 10;
					col = new Column(new Date(day * 10000.), col);
					col.x = arch.length * -300;
					arch.push(col);
					addChild(col);
				}
				col.enter(score % 10, entry['name']);
			}
			update();
		}
		
		private function update():void {
			if (arch.length == 1 || Math.floor(arch[0].date.getTime() / 86400000) > Math.floor(arch[1].date.getTime() / 86400000))
				arch[0].send(uid, key);
		}
		
	}
}

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.system.*;
import flash.text.*;
import flash.filters.DropShadowFilter;
internal class Column extends Sprite {
	
	public static const MAX:int = 10;
	private static const WIDTH:Number = 150;
	private static const HFORMAT:TextFormat = prepare_hformat();
	private static const RFORMAT:TextFormat = prepare_rformat();
	
	private static function prepare_hformat():TextFormat {
		var f:TextFormat = new TextFormat();
		f.font = 'Verdana';
		f.size = 10;
		f.color = 0xffffff;
		return f;
	}
	
	private static function prepare_rformat():TextFormat {
		var f:TextFormat = new TextFormat();
		f.font = 'Verdana';
		f.size = 12;
		f.color = 0xffffff;
		f.bold = true;
		return f;
	}
	
	private const heading:TextField = new TextField();
	private const ranks:Vector.<TextField> = new Vector.<TextField>(MAX, true);
	private const map:Object = {};
	internal var date:Date;
	private var next:Column;
	
	public function Column(d:Date, n:Column) {
		y = 50;
		date = d;
		next = n;
		heading.width = WIDTH + 143;
		heading.height = 24;
		heading.x = 7;
		heading.y = 4;
		heading.defaultTextFormat = HFORMAT;
		heading.alpha = 0.375;
		heading.selectable = false;
		heading.text =
			d.getFullYear() + '/' +
			pad(d.getMonth() + 1) + '/' +
			pad(d.getDate()) + ' ' +
			pad(d.getHours() % 12) + ':' +
			pad(d.getMinutes()) + ':' +
			pad(d.getSeconds()) + ' ' +
			(d.getHours() < 12 ? 'AM' : 'PM');
		addChild(heading);
		for (var i:int = 0; i < MAX; i++) {
			var r:TextField = new TextField();
			r.width = WIDTH;
			r.height = 22;
			r.x = 73;
			r.y = 42 + 30 * i;
			r.defaultTextFormat = RFORMAT;
			r.selectable = false;
			r.filters = [new DropShadowFilter(Math.SQRT2, 45, 0x000000, 1, 0, 0)];
			ranks[i] = r;
			addChild(r);
		}
		graphics.lineStyle(1, 0xffffff, 0.375);
		graphics.moveTo(0, 0);
		graphics.lineTo(0, 365);
	}
	
	public function enter(i:int, u:String):void {
		ranks[i].text = pad(i + 1) + '. ' + u;
		map[u] = i;
		var ix:Number = ranks[i].x + 3;
		var iy:Number = ranks[i].y + 9;
		var color:uint = getColor(u);
		graphics.lineStyle(22, color);
		graphics.moveTo(ix, iy);
		graphics.lineTo(ix + WIDTH, iy);
		if (next != null && next.map.hasOwnProperty(u)) {
			var dx:Number = 150;
			var dy:Number = next.ranks[next.map[u]].y + 9 - iy;
			graphics.lineStyle();
			graphics.beginFill(color, 0.5);
			graphics.moveTo(ix + WIDTH, iy - 11);
			graphics.curveTo(ix + WIDTH + dx * 0.25, iy - 11, ix + WIDTH + dx * 0.5, iy - 11 + dy * 0.5);
			graphics.curveTo(ix + WIDTH + dx * 0.75, iy - 11 + dy, ix + WIDTH + dx, iy - 11 + dy);
			graphics.lineTo(ix + WIDTH + dx, iy + 11 + dy);
			graphics.curveTo(ix + WIDTH + dx * 0.75, iy + 11 + dy, ix + WIDTH + dx * 0.5, iy + 11 + dy * 0.5);
			graphics.curveTo(ix + WIDTH + dx * 0.25, iy + 11, ix + WIDTH, iy + 11);
			graphics.endFill();
		}
	}
		
	internal function send(uid:String, key:String):void {
		heading.appendText('*');
		var score:int = (int) (date.getTime() / 10000) * 10;
		for (var u:String in map) {
			var req:URLRequest = new URLRequest('http://api.wonderfl.net/score/' + uid + '_dev');
			req.method = URLRequestMethod.POST;
			req.data = new URLVariables();
			req.data['api_key'] = key;
			req.data['name'] = u;
			req.data['score'] = score + map[u];
			new URLLoader(req);
		}
	}

	private static function pad(n:int):String {
		return n < 10 ? '0' + n : n.toString();
	}
	
	private static function getColor(s:String):uint {
		var r:uint = 0;
		for (var i:int = 0; i < s.length; i++)
			r += s.charCodeAt(i);
		r = r * 7919 % 0x600;
		r =
			0x010000 * Math.max(0, Math.min(0xff, Math.abs(r - 0x300) - 0x100)) +
			0x000100 * Math.max(0, Math.min(0xff, 0x200 - Math.abs(r - 0x200))) +
			           Math.max(0, Math.min(0xff, 0x200 - Math.abs(r - 0x400)));
		return (r >> 2 & 0x3f3f3f) + (r >> 1 & 0x7f7f7f);
	}
	
}