/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bwVf
 */

/*
 * Picasa Web Albums Data API
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
 * 参考
 * http://wonderfl.net/code/95d18286b23549ece13d4933dffd64a6cf550386
 * 
*/
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.filters.DropShadowFilter;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	public class Main extends Sprite{
		public function Main() {
			//Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteRSS);
			//var URLstr:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&access=public&filter=1&q=waterdrop&isvideo=false&imglic=commercial&max-results=3&imgmax=288";
			//YahooPipesの汎用feedProxy
			var URLstr:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=f4f6c98189a88373b9bfd4fe6128c018&_render=rss&url=";
			//encodeURIComponentでエスケープして、feedProxyにくっつける。
			URLstr += encodeURIComponent("http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&access=public&filter=1&q=waterdrop&isvideo=false&imglic=commercial&max-results=3&imgmax=288");
			myURLLoader.load(new URLRequest(URLstr));
		}
		
		private function onCompleteRSS(e:Event):void {
			var myXML:XML = new XML(e.currentTarget.data);
			default xml namespace = new Namespace("http://search.yahoo.com/mrss/");
			var tf:TextField = new TextField();
			tf.text = myXML;
			tf.textColor = 0xCCCCCC;
			tf.wordWrap = true;
			tf.width = tf.height = 465;
			addChild(tf);
			
			trace(myXML)
			
			var htmldata:String = "Title:" + myXML.channel.item[0].title + "<br>";
			htmldata += "Credit:" + myXML.channel.item[0].author + "<br>";
			htmldata += "<a href='" + myXML.channel.item[0].link + "'>" + myXML.channel.item[0].link + "</a>";
			var fld:TextField = new TextField();
			fld.autoSize = TextFieldAutoSize.LEFT;
			fld.width = 300;
			fld.x = 50;
			fld.y = 50;
			fld.multiline = true;
			fld.htmlText = htmldata;
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			fld.filters = [dsf];
			addChild(fld);
            
			var myLoader:Loader = new Loader();
			var myLoaderContext:LoaderContext = new LoaderContext(true);
			var myURLRequest:URLRequest = new URLRequest(myXML.channel.item[0].group.content.@url);
			myLoader.load(myURLRequest, myLoaderContext);
			myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
		}
		
		private function onCompleteImg(e:Event):void {
			var myBitmap:Bitmap = e.target.content;
			var myBitmapData:BitmapData = new BitmapData(myBitmap.width,myBitmap.height);
			myBitmapData.draw(myBitmap);
			var mySprite:Sprite = new Sprite();
			mySprite.graphics.beginBitmapFill (myBitmapData);
			mySprite.graphics.drawRoundRect(0, 0, myBitmap.width, myBitmap.height, 50, 50);
			mySprite.x = 50;
			mySprite.y = 100;
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			mySprite.filters = [dsf];
			addChild(mySprite);
		}
	}
}
